use Test::More tests => 5;

use FindBin;
use lib "$FindBin::Bin/../lib";
use strict;
use warnings;
use Hash::MD5 qw( sum_hash );

my $check_sum1 = sum_hash( { string => "This is a test string.", number => 'This is a another string.'});
my $check_sum2 = sum_hash( { number => 'This is a another string.', string => "This is a test string."});
ok(($check_sum1 eq $check_sum2) == 1, 'test compare strings');

$check_sum1 = sum_hash(  { string => 123, number => 321});
$check_sum2 = sum_hash(  { number => 321, string => 123});
ok(($check_sum1 eq $check_sum2) == 1, 'test compare number');

$check_sum1 = sum_hash(  { string => 321, number => 123});
$check_sum2 = sum_hash(  { number => 321, string => 123});
ok(($check_sum1 eq $check_sum2) != 1, 'test compare number');

$check_sum1 = sum_hash({ number => 321,string => "This is a test string."});
$check_sum2 = sum_hash({ string => "This is a test string.", number => 321});
ok(($check_sum1 eq $check_sum2) == 1, 'test compare mixed');

$check_sum1 = sum_hash({ number => 321,string => "This is a test string.", a => [1,2,3]});
$check_sum2 = sum_hash({ string => "This is a test string.", number => 321, a => [1,2,3]});
ok(($check_sum1 eq $check_sum2) == 1, 'test compare mixed');

