/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 */
public class ImageSurface extends Surface {

    public ImageSurface(Format format, int width, int height) {
        super(cairo_image_surface_create(format.getValue(), width, height));
    }

    public ImageSurface(char[] data, Format format, int width, int height,
            int stride) {
        super(cairo_image_surface_create_for_data(data, format.getValue(),
                width, height, stride));
    }

    ImageSurface(Handle hndl) {
        super(hndl);
    }

    public int getWidth() {
        return cairo_image_surface_get_width(getHandle());
    }

    public int getHeight() {
        return cairo_image_surface_get_height(getHandle());
    }

    static public ImageSurface createFromPNG(String filename) {
        return new ImageSurface(cairo_image_surface_create_from_png(filename));
    }

    /*
     * Native calls
     */
    native static final private Handle cairo_image_surface_create(int format,
            int width, int height);

    native static final private Handle cairo_image_surface_create_for_data(
            char[] data, int format, int width, int height, int stride);

    native static final private int cairo_image_surface_get_width(Handle obj);

    native static final private int cairo_image_surface_get_height(Handle obj);

    // TODO: JNI and exception handling
    native static final private Handle cairo_image_surface_create_from_png(
            String filename);
    // TODO:
    // native static final private Handle
    // cairo_image_surface_create_from_png_stream(String func);
    // cairo_surface_t *
    // cairo_image_surface_create_from_png_stream (cairo_read_func_t read_func,
    // void *closure);

}
