/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_Pattern
#define _Included_org_freedesktop_cairo_Pattern
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_create_for_surface
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1create_1for_1surface
  (JNIEnv *env, jclass cls, jobject surface)
{
	cairo_surface_t *surface_g;
	cairo_pattern_t *pat;
	
	surface_g = (cairo_surface_t*)getPointerFromHandle(env, surface);
	
	pat = cairo_pattern_create_for_surface(surface_g);
	
	return getHandleFromPointer(env, pat);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_create_rgb
 * Signature: (DDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1create_1rgb
  (JNIEnv *env, jclass cls, jdouble red, jdouble green, jdouble blue)
{
	cairo_pattern_t *pattern;
	
	pattern = cairo_pattern_create_rgb(red, green, blue);
	return getHandleFromPointer(env, pattern);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_create_rgba
 * Signature: (DDDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1create_1rgba
  (JNIEnv *env, jclass cls, jdouble red, jdouble green, jdouble blue, jdouble alpha)
{
	cairo_pattern_t *pattern;
	
	pattern = cairo_pattern_create_rgba(red, green, blue, alpha);
	return getHandleFromPointer(env, pattern);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_create_linear
 * Signature: (DDDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1create_1linear
  (JNIEnv *env, jclass cls, jdouble x1, jdouble y1, jdouble x2, jdouble y2)
{
	cairo_pattern_t *pat;
	
	pat = cairo_pattern_create_linear(x1, y1, x2, y2);
	
	return getHandleFromPointer(env, pat);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_create_radial
 * Signature: (DDDDDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1create_1radial
  (JNIEnv *env, jclass cls, jdouble x1, jdouble y1, jdouble radius1, 
  	jdouble x2, jdouble y2, jdouble radius2)
 {
	cairo_pattern_t *pat;
	
	pat = cairo_pattern_create_radial(x1, y1, radius1, x2, y2, radius2);

 	return getHandleFromPointer(env, pat);
 }


/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_destroy
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1destroy
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_pattern_destroy(pat);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_add_color_stop_rgb
 * Signature: (Lorg/gnu/glib/Handle;DDDDD)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1add_1color_1stop_1rgb
  (JNIEnv *env, jclass cls, jobject obj, jdouble offset, jdouble red, jdouble green, 
  		jdouble blue)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_pattern_add_color_stop_rgb(pat, offset, red, green, blue);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_add_color_stop_rgba
 * Signature: (Lorg/gnu/glib/Handle;DDDDD)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1add_1color_1stop_1rgba
  (JNIEnv *env, jclass cls, jobject obj, jdouble offset, jdouble red, jdouble green, 
  		jdouble blue, jdouble alpha)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_pattern_add_color_stop_rgba(pat, offset, red, green, blue, alpha);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_set_matrix
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1set_1matrix
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_pattern_set_matrix(pat, matrix_g);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_get_matrix
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1get_1matrix
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_pattern_get_matrix(pat, matrix_g);
	updateHandle(env, matrix, matrix_g);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_set_extend
 * Signature: (Lorg/gnu/glib/Handle;I)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1set_1extend
  (JNIEnv *env, jclass cls, jobject obj, jint extend)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_pattern_set_extend(pat, (cairo_extend_t)extend);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_get_extend
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1get_1extend
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_pattern_get_extend(pat);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_set_filter
 * Signature: (Lorg/gnu/glib/Handle;I)I
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1set_1filter
  (JNIEnv *env, jclass cls, jobject obj, jint filter)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	cairo_pattern_set_filter(pat, (cairo_filter_t)filter);
}

/*
 * Class:     org_freedesktop_cairo_Pattern
 * Method:    cairo_pattern_get_filter
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Pattern_cairo_1pattern_1get_1filter
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_pattern_t *pat = (cairo_pattern_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_pattern_get_filter(pat);
}


#ifdef __cplusplus
}
#endif
#endif
