/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.Screen;
import sun.awt.X11.Visual;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XWindowAttributes
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 92;
    }

    @Override
    public int getDataSize() {
        return XWindowAttributes.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XWindowAttributes(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XWindowAttributes() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XWindowAttributes.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_x() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_x(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_y() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_y(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public int get_border_width() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_border_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 16L, n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + 20L, n);
    }

    public Visual get_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + 24L) != 0L ? new Visual(Native.getLong(this.pData + 24L) + (long)(n * 32)) : null;
    }

    public long get_visual() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + 24L, l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 28L);
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + 28L, l);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + 32L);
    }

    public void set_class(int n) {
        log.finest("");
        Native.putInt(this.pData + 32L, n);
    }

    public int get_bit_gravity() {
        log.finest("");
        return Native.getInt(this.pData + 36L);
    }

    public void set_bit_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + 36L, n);
    }

    public int get_win_gravity() {
        log.finest("");
        return Native.getInt(this.pData + 40L);
    }

    public void set_win_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + 40L, n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + 44L);
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + 44L, n);
    }

    public long get_backing_planes() {
        log.finest("");
        return Native.getLong(this.pData + 48L);
    }

    public void set_backing_planes(long l) {
        log.finest("");
        Native.putLong(this.pData + 48L, l);
    }

    public long get_backing_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 52L);
    }

    public void set_backing_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 52L, l);
    }

    public boolean get_save_under() {
        log.finest("");
        return Native.getBool(this.pData + 56L);
    }

    public void set_save_under(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + 56L, bl);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + 60L);
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + 60L, l);
    }

    public boolean get_map_installed() {
        log.finest("");
        return Native.getBool(this.pData + 64L);
    }

    public void set_map_installed(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + 64L, bl);
    }

    public int get_map_state() {
        log.finest("");
        return Native.getInt(this.pData + 68L);
    }

    public void set_map_state(int n) {
        log.finest("");
        Native.putInt(this.pData + 68L, n);
    }

    public long get_all_event_masks() {
        log.finest("");
        return Native.getLong(this.pData + 72L);
    }

    public void set_all_event_masks(long l) {
        log.finest("");
        Native.putLong(this.pData + 72L, l);
    }

    public long get_your_event_mask() {
        log.finest("");
        return Native.getLong(this.pData + 76L);
    }

    public void set_your_event_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 76L, l);
    }

    public long get_do_not_propagate_mask() {
        log.finest("");
        return Native.getLong(this.pData + 80L);
    }

    public void set_do_not_propagate_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 80L, l);
    }

    public boolean get_override_redirect() {
        log.finest("");
        return Native.getBool(this.pData + 84L);
    }

    public void set_override_redirect(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + 84L, bl);
    }

    public Screen get_screen(int n) {
        log.finest("");
        return Native.getLong(this.pData + 88L) != 0L ? new Screen(Native.getLong(this.pData + 88L) + (long)(n * 80)) : null;
    }

    public long get_screen() {
        log.finest("");
        return Native.getLong(this.pData + 88L);
    }

    public void set_screen(long l) {
        log.finest("");
        Native.putLong(this.pData + 88L, l);
    }

    @Override
    String getName() {
        return "XWindowAttributes";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(920);
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("border_width = ").append(this.get_border_width()).append(", ");
        stringBuilder.append("depth = ").append(this.get_depth()).append(", ");
        stringBuilder.append("visual = ").append(this.get_visual()).append(", ");
        stringBuilder.append("root = ").append(this.get_root()).append(", ");
        stringBuilder.append("class = ").append(this.get_class()).append(", ");
        stringBuilder.append("bit_gravity = ").append(this.get_bit_gravity()).append(", ");
        stringBuilder.append("win_gravity = ").append(this.get_win_gravity()).append(", ");
        stringBuilder.append("backing_store = ").append(this.get_backing_store()).append(", ");
        stringBuilder.append("backing_planes = ").append(this.get_backing_planes()).append(", ");
        stringBuilder.append("backing_pixel = ").append(this.get_backing_pixel()).append(", ");
        stringBuilder.append("save_under = ").append(this.get_save_under()).append(", ");
        stringBuilder.append("colormap = ").append(this.get_colormap()).append(", ");
        stringBuilder.append("map_installed = ").append(this.get_map_installed()).append(", ");
        stringBuilder.append("map_state = ").append(this.get_map_state()).append(", ");
        stringBuilder.append("all_event_masks = ").append(this.get_all_event_masks()).append(", ");
        stringBuilder.append("your_event_mask = ").append(this.get_your_event_mask()).append(", ");
        stringBuilder.append("do_not_propagate_mask = ").append(this.get_do_not_propagate_mask()).append(", ");
        stringBuilder.append("override_redirect = ").append(this.get_override_redirect()).append(", ");
        stringBuilder.append("screen = ").append(this.get_screen()).append(", ");
        return stringBuilder.toString();
    }
}

