/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.ArrayList;
import java.util.HashMap;

public class LazyNameMap
implements Cloneable {
    private HashMap map = new HashMap();
    private ArrayList names = new ArrayList();
    private boolean clean = false;

    public boolean isClean() {
        return this.clean;
    }

    public void setValue(String string, int n) {
        if (this.clean) {
            this.map = (HashMap)this.map.clone();
            this.names = (ArrayList)this.names.clone();
            this.clean = false;
        }
        this.map.put(string, new NameCarrier(n));
    }

    public NameCarrier get(String string) {
        return (NameCarrier)this.map.get(string);
    }

    public NameCarrier remove(String string) {
        NameCarrier nameCarrier = (NameCarrier)this.map.get(string);
        if (nameCarrier == null) {
            return null;
        }
        if (this.clean) {
            this.map = (HashMap)this.map.clone();
            this.names = (ArrayList)this.names.clone();
            this.clean = false;
        }
        return (NameCarrier)this.map.remove(string);
    }

    public Object clone() {
        try {
            LazyNameMap lazyNameMap = (LazyNameMap)super.clone();
            lazyNameMap.clean = true;
            this.clean = true;
            return lazyNameMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed for some reason");
        }
    }

    public static class NameCarrier {
        private int value;
        private int counter;

        public NameCarrier(int n) {
            this.value = n;
            this.counter = 1;
        }

        public int getValue() {
            return this.value;
        }

        public int getInstanceCount() {
            return this.counter;
        }

        public void increase() {
            ++this.counter;
        }

        public void decrease() {
            --this.counter;
        }
    }
}

