'''OpenGL extension NV.memory_attachment

This module customises the behaviour of the 
OpenGL.raw.GL.NV.memory_attachment to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension extends the memory objects introduced with EXT_memory_object
	to allow existing textures and buffers to be migrated to an imported memory
	allocation.  The primary use-case of this extension is plug-in development
	where resource management (creation, deletion, sizing etc.) is handled by
	inaccessible host application code.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/memory_attachment.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.memory_attachment import *
from OpenGL.raw.GL.NV.memory_attachment import _EXTENSION_NAME

def glInitMemoryAttachmentNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION