/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.readline.terminal.TerminalDevice;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.tty.Capability;
import org.aesh.utils.Config;
import org.aesh.utils.InfoCmp;

public class DeviceBuilder {
    private String name;
    private final Logger LOGGER = LoggerUtil.getLogger(this.getClass().getName());

    private DeviceBuilder() {
    }

    public static DeviceBuilder builder() {
        return new DeviceBuilder();
    }

    public DeviceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TerminalDevice build() {
        if (this.name == null) {
            this.name = Config.isOSPOSIXCompatible() ? "ansi" : "windows";
        }
        String data = this.getCapabilityFromType();
        TerminalDevice device = new TerminalDevice(this.name);
        if (data != null) {
            HashSet<Capability> bools = new HashSet<Capability>();
            HashMap<Capability, Integer> ints = new HashMap<Capability, Integer>();
            HashMap<Capability, String> strings = new HashMap<Capability, String>();
            InfoCmp.parseInfoCmp(data, bools, ints, strings);
            device.addAllCapabilityBooleans(bools);
            device.addAllCapabilityInts(ints);
            device.addAllCapabilityStrings(strings);
        }
        return device;
    }

    private String getCapabilityFromType() {
        try {
            return InfoCmp.getDefaultInfoCmp(this.name);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Unable to retrieve infocmp for type " + this.name, e);
            return null;
        }
    }
}

