/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.almworks.util.Const;
import org.almworks.util.Util;

public class ArrayUtil {
    public static boolean containsAll(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        int n5;
        if (lArray.length == 0) {
            return lArray2.length == 0;
        }
        if (lArray2.length == 0) {
            return true;
        }
        assert (ArrayUtil.isSorted(lArray, n, n2));
        assert (ArrayUtil.isSorted(lArray2, n3, n4));
        int n6 = 0;
        for (n5 = 0; n5 < n4; ++n5) {
            long l = lArray2[n3 + n5];
            while (n6 < n2 && lArray[n + n6] != l) {
                ++n6;
            }
            if (n6 == n2) break;
        }
        return n5 == n4;
    }

    public static boolean hasIntersection(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        if (n2 == 0 || n4 == 0) {
            return false;
        }
        assert (ArrayUtil.isSorted(lArray, n, n2));
        assert (ArrayUtil.isSorted(lArray2, n3, n4));
        int n5 = n + n2;
        int n6 = n3 + n4;
        int n7 = n3;
        long l = lArray2[n7++];
        for (int i = n; i < n5; ++i) {
            long l2 = lArray[i];
            while (n7 < n6 && l < l2) {
                l = lArray2[n7++];
            }
            if (l == l2) {
                return true;
            }
            if (n7 != n6) continue;
            return false;
        }
        return false;
    }

    public static boolean isSorted(long[] lArray, int n, int n2) {
        long l = Long.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            long l2 = lArray[i + n];
            if (l2 < l) {
                return false;
            }
            l = l2;
        }
        return true;
    }

    public static boolean isSorted(int[] nArray, int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i + n];
            if (n4 < n3) {
                return false;
            }
            n3 = n4;
        }
        return true;
    }

    public static boolean isUniqueSorted(int[] nArray, int n, int n2) {
        if (nArray == null || n2 < 2) {
            return true;
        }
        int n3 = nArray[n];
        for (int i = n + 1; i < n + n2; ++i) {
            int n4 = nArray[i];
            if (n4 <= n3) {
                return false;
            }
            n3 = n4;
        }
        return true;
    }

    public static boolean isUniqueSorted(int[] nArray) {
        if (nArray == null) {
            return true;
        }
        return ArrayUtil.isUniqueSorted(nArray, 0, nArray.length);
    }

    public static boolean isSorted(int[] nArray) {
        return nArray == null || ArrayUtil.isSorted(nArray, 0, nArray.length);
    }

    public static boolean equals(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (lArray[n++] == lArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, int n, int n2, Object[] objectArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (Util.equals(objectArray[n++], objectArray2[n3++])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        return ArrayUtil.equals(lArray, 0, lArray.length, lArray2, 0, lArray2.length);
    }

    public static boolean equals(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[n++] == nArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        return ArrayUtil.equals(nArray, 0, nArray.length, nArray2, 0, nArray2.length);
    }

    public static boolean isSorted(Object[] objectArray, Comparator comparator) {
        for (int i = 0; i < objectArray.length - 1; ++i) {
            if (comparator.compare(objectArray[i], objectArray[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static void reverse(Object[] objectArray, int n, int n2) {
        int n3 = n + n2 - 1;
        for (int i = 0; i < n2 / 2; ++i) {
            int n4 = n + i;
            int n5 = n3 - i;
            Object object = objectArray[n4];
            objectArray[n4] = objectArray[n5];
            objectArray[n5] = object;
        }
    }

    public static void reverse(Object[] objectArray) {
        ArrayUtil.reverse(objectArray, 0, objectArray.length);
    }

    public static void quicksort(Object[] objectArray, Comparator comparator) {
        ArrayUtil.sort1(objectArray, 0, objectArray.length, comparator);
    }

    private static void sort1(Object[] objectArray, int n, int n2, Comparator comparator) {
        int n3;
        int n4;
        int n5;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray[j - 1], objectArray[j]) > 0; --j) {
                    ArrayUtil.swap(objectArray, j, j - 1);
                }
            }
            return;
        }
        int n6 = n + (n2 >> 1);
        if (n2 > 7) {
            int n7 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n7 = ArrayUtil.med3(objectArray, n7, n7 + n4, n7 + 2 * n4, comparator);
                n6 = ArrayUtil.med3(objectArray, n6 - n4, n6, n6 + n4, comparator);
                n5 = ArrayUtil.med3(objectArray, n5 - 2 * n4, n5 - n4, n5, comparator);
            }
            n6 = ArrayUtil.med3(objectArray, n7, n6, n5, comparator);
        }
        Object object = objectArray[n6];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && comparator.compare(objectArray[n4], object) <= 0) {
                if (objectArray[n4] == object) {
                    ArrayUtil.swap(objectArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && comparator.compare(objectArray[n3], object) >= 0) {
                if (objectArray[n3] == object) {
                    ArrayUtil.swap(objectArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            ArrayUtil.swap(objectArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        ArrayUtil.vecswap(objectArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        ArrayUtil.vecswap(objectArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            ArrayUtil.sort1(objectArray, n, n10, comparator);
        }
        if ((n10 = n8 - n3) > 1) {
            ArrayUtil.sort1(objectArray, n9 - n10, n10, comparator);
        }
    }

    public static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void vecswap(Object[] objectArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            ArrayUtil.swap(objectArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(Object[] objectArray, int n, int n2, int n3, Comparator comparator) {
        return comparator.compare(objectArray[n], objectArray[n2]) < 0 ? (comparator.compare(objectArray[n2], objectArray[n3]) < 0 ? n2 : (comparator.compare(objectArray[n], objectArray[n3]) < 0 ? n3 : n)) : (comparator.compare(objectArray[n2], objectArray[n3]) > 0 ? n2 : (comparator.compare(objectArray[n], objectArray[n3]) > 0 ? n3 : n));
    }

    public static int min(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return Integer.MIN_VALUE;
        }
        int n = Integer.MAX_VALUE;
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static int binarySearch(int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >> 1;
            int n7 = nArray[n6];
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(long l, long[] lArray, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            long l2 = lArray[n5];
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            if (l2 > l) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static Object[] ensureCapacity(Object[] objectArray, int n) {
        return ArrayUtil.ensureCapacity(objectArray, n, true);
    }

    public static Object[] ensureCapacity(Object[] objectArray, int n, boolean bl) {
        int n2 = objectArray.length;
        if (n2 >= n) {
            return objectArray;
        }
        return (Object[])ArrayUtil.reallocArray(objectArray, Math.max(16, Math.max(n, n2 * 2)), bl);
    }

    public static long[] ensureCapacity(long[] lArray, int n) {
        int n2;
        int n3 = n2 = lArray == null ? -1 : lArray.length;
        if (n2 >= n) {
            return lArray;
        }
        if (n == 0) {
            return Const.EMPTY_LONGS;
        }
        return ArrayUtil.reallocArray(lArray, Math.max(16, Math.max(n, n2 * 2)));
    }

    public static int[] ensureCapacity(int[] nArray, int n) {
        int n2;
        int n3 = n2 = nArray == null ? -1 : nArray.length;
        if (n2 >= n) {
            return nArray;
        }
        if (n == 0) {
            return Const.EMPTY_INTS;
        }
        return ArrayUtil.reallocArray(nArray, Math.max(16, Math.max(n, n2 * 2)));
    }

    public static Object reallocArray(Object object, int n) {
        return ArrayUtil.reallocArray(object, n, true);
    }

    public static Object reallocArray(Object object, int n, boolean bl) {
        int n2 = Array.getLength(object);
        if (n2 == n) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        if (bl) {
            System.arraycopy(object, 0, object2, 0, Math.min(n, n2));
        }
        return object2;
    }

    public static long[] reallocArray(long[] lArray, int n) {
        int n2;
        assert (n >= 0) : n;
        int n3 = n2 = lArray == null ? -1 : lArray.length;
        if (n2 == n) {
            return lArray;
        }
        if (n == 0) {
            return Const.EMPTY_LONGS;
        }
        long[] lArray2 = new long[n];
        int n4 = Math.min(n, n2);
        if (n4 > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n4);
        }
        return lArray2;
    }

    public static int[] reallocArray(int[] nArray, int n) {
        int n2;
        assert (n >= 0) : n;
        int n3 = n2 = nArray == null ? -1 : nArray.length;
        if (n2 == n) {
            return nArray;
        }
        if (n == 0) {
            return Const.EMPTY_INTS;
        }
        int[] nArray2 = new int[n];
        int n4 = Math.min(n, n2);
        if (n4 > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n4);
        }
        return nArray2;
    }

    public static int indexOf(int[] nArray, int n) {
        return ArrayUtil.indexOf(nArray, 0, nArray.length, n);
    }

    public static int indexOf(long[] lArray, long l) {
        return ArrayUtil.indexOf(lArray, 0, lArray.length, l);
    }

    public static int indexOf(char[] cArray, char c) {
        return ArrayUtil.indexOf(cArray, 0, cArray.length, c);
    }

    public static int indexOf(long[] lArray, int n, int n2, long l) {
        for (int i = n; i < n2; ++i) {
            if (lArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (nArray[i] != n3) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int[] arrayCopy(int[] nArray) {
        return ArrayUtil.arrayCopy(nArray, 0, nArray.length);
    }

    public static int[] arrayCopy(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return Const.EMPTY_INTS;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static byte[] arrayCopy(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return Const.EMPTY_BYTES;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static Object[] arrayCopy(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        return ArrayUtil.arrayCopy(objectArray, 0, objectArray.length);
    }

    public static Object[] arrayCopy(Object[] objectArray, int n, int n2) {
        if (objectArray == null) {
            return objectArray;
        }
        assert (n2 != 0);
        assert (n >= 0) : n;
        assert (n2 >= 0) : n2;
        assert (objectArray.length >= n + n2) : objectArray.length + " " + n + " " + n2;
        Object[] objectArray2 = ArrayUtil.allocSameClassArray(objectArray, n2);
        System.arraycopy(objectArray, n, objectArray2, 0, n2);
        return objectArray2;
    }

    private static Object[] allocSameClassArray(Object[] objectArray, int n) {
        return (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
    }

    public static long[] arrayCopy(long[] lArray) {
        return ArrayUtil.arrayCopy(lArray, 0, lArray.length);
    }

    public static long[] arrayCopy(long[] lArray, int n, int n2) {
        if (n2 == 0) {
            return Const.EMPTY_LONGS;
        }
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, n, lArray2, 0, n2);
        return lArray2;
    }

    public static boolean isSorted(long[] lArray) {
        return ArrayUtil.isSorted(lArray, 0, lArray.length);
    }

    public static void reverse(int[] nArray) {
        int n = 0;
        for (int i = nArray.length - 1; n < i; ++n, --i) {
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtil.indexOf(objectArray, 0, objectArray.length, object);
    }

    public static int indexOf(Object[] objectArray, int n, int n2, Object object) {
        for (int i = n; i < n2; ++i) {
            if (!Util.equals(objectArray[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static long[] join(long[] ... lArray) {
        if (lArray.length == 0) {
            return Const.EMPTY_LONGS;
        }
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == null || lArray[i].length <= 0) continue;
            n = n == -1 ? i : -2;
            n2 += lArray[i].length;
        }
        if (n >= 0) {
            return lArray[n];
        }
        long[] lArray2 = new long[n2];
        int n3 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == null || lArray[i].length <= 0) continue;
            int n4 = lArray[i].length;
            System.arraycopy(lArray[i], 0, lArray2, n3, n4);
            n3 += n4;
        }
        return lArray2;
    }

    public static int[] join(int[] ... nArray) {
        if (nArray.length == 0) {
            return Const.EMPTY_INTS;
        }
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null || nArray[i].length <= 0) continue;
            n = n == -1 ? i : -2;
            n2 += nArray[i].length;
        }
        if (n >= 0) {
            return nArray[n];
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null || nArray[i].length <= 0) continue;
            int n4 = nArray[i].length;
            System.arraycopy(nArray[i], 0, nArray2, n3, n4);
            n3 += n4;
        }
        return nArray2;
    }

    public static Object[] prepend(Object[] objectArray, Object ... objectArray2) {
        if (objectArray2 == null || objectArray2.length == 0) {
            return ArrayUtil.arrayCopy(objectArray);
        }
        Object[] objectArray3 = ArrayUtil.allocSameClassArray(objectArray, objectArray.length + objectArray2.length);
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, objectArray2.length, objectArray.length);
        return objectArray3;
    }

    public static String toString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        String string = "";
        for (int n : nArray) {
            stringBuilder.append(string);
            stringBuilder.append(n);
            string = ",";
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Object[] collectionToArray(Collection collection, Object[] objectArray) {
        return collection.isEmpty() ? objectArray : collection.toArray((Object[])ArrayUtil.reallocArray(objectArray, collection.size(), false));
    }

    public static int[] copyWithoutIndex(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        if (n == nArray.length - 1) {
            return nArray2;
        }
        System.arraycopy(nArray, n + 1, nArray2, n, nArray2.length - n);
        return nArray2;
    }

    public static Object[] copyWithoutIndex(Object[] objectArray, int n) {
        if (n < 0 || objectArray.length == 0) {
            return objectArray;
        }
        Object[] objectArray2 = ArrayUtil.allocSameClassArray(objectArray, objectArray.length - 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        if (n == objectArray.length - 1) {
            return objectArray2;
        }
        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
        return objectArray2;
    }

    public static int[] prepend(int[] nArray, int ... nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static int removeSubsequentDuplicates(int[] nArray, int n, int n2) {
        if (n2 < 2) {
            return n2;
        }
        n2 += n;
        for (int i = n; i < n2 - 1; ++i) {
            int n3;
            int n4 = nArray[i];
            for (n3 = i + 1; n3 < n2 && n4 == nArray[n3]; ++n3) {
            }
            if (n3 > i + 1) {
                System.arraycopy(nArray, n3, nArray, i + 1, n2 - n3);
            }
            n2 -= n3 - i - 1;
        }
        return n2 - n;
    }

    public static int removeSubsequentDuplicates(long[] lArray, int n, int n2) {
        if (n2 < 2) {
            return n2;
        }
        n2 += n;
        for (int i = n; i < n2 - 1; ++i) {
            int n3;
            long l = lArray[i];
            for (n3 = i + 1; n3 < n2 && l == lArray[n3]; ++n3) {
            }
            if (n3 > i + 1) {
                System.arraycopy(lArray, n3, lArray, i + 1, n2 - n3);
            }
            n2 -= n3 - i - 1;
        }
        return n2 - n;
    }

    public static int removeSubsequentDuplicates(Object[] objectArray, int n, int n2) {
        if (n2 < 2) {
            return n2;
        }
        n2 += n;
        for (int i = n; i < n2 - 1; ++i) {
            int n3;
            Object object = objectArray[i];
            for (n3 = i + 1; n3 < n2 && Util.equals(object, objectArray[n3]); ++n3) {
            }
            if (n3 > i + 1) {
                System.arraycopy(objectArray, n3, objectArray, i + 1, n2 - n3);
            }
            n2 -= n3 - i - 1;
        }
        return n2 - n;
    }

    public static int[] indexArray(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    public static int indexOfNear(int[] nArray, int n, int n2, int n3) {
        if (n3 < n && nArray[n3] == n2) {
            return n3;
        }
        int n4 = Math.min(n3, n - 1);
        for (int i = n3; n4 >= 0 || i < n; --n4, ++i) {
            if (n4 >= 0 && nArray[n4] == n2) {
                return n4;
            }
            if (i >= n || nArray[i] != n2) continue;
            return i;
        }
        return -1;
    }

    public static int sum(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += nArray[i];
        }
        return n3;
    }

    public static int binarySearch(int n, int[] nArray) {
        return ArrayUtil.binarySearch(n, nArray, 0, nArray.length);
    }

    public static boolean equalDifferentElements(Object[] objectArray, List list) {
        if (objectArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object e = list.get(i);
            if (ArrayUtil.contains(objectArray, e)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        for (Object object2 : objectArray) {
            if (!Util.equals(object2, object)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        return Arrays.equals(byArray, byArray2);
    }

    public static int binarySearch(Object[] objectArray, int n, int n2, Object object, Comparator comparator) {
        if (comparator == null) {
            return ArrayUtil.binarySearch(objectArray, n, n2, object);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Object object2 = objectArray[n5];
            int n6 = comparator.compare(object2, object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Comparable comparable = (Comparable)objectArray[n5];
            int n6 = comparable.compareTo(object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static Object[] copyWith(Object[] objectArray, Object object) {
        Object[] objectArray2 = (Object[])ArrayUtil.reallocArray(objectArray, objectArray.length + 1, true);
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public static Object[] insert(Object[] objectArray, int n, int n2, Object object) {
        objectArray = ArrayUtil.ensureCapacity(objectArray, n + 1);
        System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
        objectArray[n2] = object;
        return objectArray;
    }

    public static long[] insert(long[] lArray, int n, int n2, long l) {
        lArray = ArrayUtil.ensureCapacity(lArray, n + 1);
        System.arraycopy(lArray, n2, lArray, n2 + 1, n - n2);
        lArray[n2] = l;
        return lArray;
    }

    public static int removeSubsequentEquals(Object[] objectArray, Comparator comparator) {
        if (objectArray == null) {
            return 0;
        }
        return ArrayUtil.removeSubsequentEquals(objectArray, 0, objectArray.length, comparator);
    }

    public static int removeSubsequentEquals(Object[] objectArray, int n, int n2, Comparator comparator) {
        if (objectArray == null) {
            return 0;
        }
        if (n + 1 >= n2) {
            return n2 - n;
        }
        int n3 = n + 1;
        Object object = objectArray[n];
        for (int i = n + 1; i < n2; ++i) {
            Object object2 = objectArray[i];
            if (comparator.compare(object, object2) == 0) continue;
            object = object2;
            objectArray[n3] = object2;
            ++n3;
        }
        return n3 - n;
    }

    public static int removeSubsequentEqualDuplicates(Object[] objectArray, int n, int n2) {
        if (n2 < 2) {
            return n2;
        }
        n2 += n;
        for (int i = n; i < n2 - 1; ++i) {
            int n3;
            Object object = objectArray[i];
            for (n3 = i + 1; n3 < n2 && Util.equals(object, objectArray[n3]); ++n3) {
            }
            if (n3 > i + 1) {
                System.arraycopy(objectArray, n3, objectArray, i + 1, n2 - n3);
            }
            n2 -= n3 - i - 1;
        }
        return n2 - n;
    }
}

