/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.MoreNodesNode;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.heapviewer.utils.SortedObjectsBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.Formatters;

abstract class MoreObjectsNode<T>
extends MoreNodesNode {
    private static final int AGGREGATION = 1000;
    private static final int MAX_BUFFER_SIZE = 1000000;
    private T[] previousObjects;
    private final T previousObject;
    private final int previousObjectOffset;
    private int lastKnownPreviousObjectIndex;
    private final int objectsCount;
    private final int iteratorObjectsCount;
    private final int nodesCount;
    private final int nodesOffset;

    MoreObjectsNode(String text, int objectsCount, int iteratorObjectsCount, T previousObject, int previousObjectOffset) {
        super(text);
        this.objectsCount = objectsCount;
        this.iteratorObjectsCount = iteratorObjectsCount;
        this.nodesCount = (int)Math.ceil((double)(objectsCount - previousObjectOffset + 1) / 1000.0);
        this.nodesOffset = (int)Math.floor((double)(previousObjectOffset + 1) / 1000.0);
        this.previousObject = previousObject;
        this.previousObjectOffset = previousObjectOffset;
        this.resetChildren();
    }

    protected abstract boolean sorts(DataType var1);

    protected abstract HeapViewerNode createNode(T var1);

    protected abstract Iterator<T> objectsIterator(int var1, Progress var2);

    protected String getSamplesContainerString(String objectsCount) {
        return Bundle.MoreObjectsNode_SamplesContainer(objectsCount);
    }

    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.MoreObjectsNode_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    @Override
    protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        this.lastKnownPreviousObjectIndex = -1;
        if (this.nodesCount == 1) {
            return this.computeChildren(-1, heap, viewID, null, dataTypes, sortOrders, progress);
        }
        this.previousObjects = new Object[this.nodesCount - 1];
        Format format = Formatters.numberFormat();
        int containersOffset = this.objectsCount >= 1000 ? 1 : 0;
        HeapViewerNode[] nodes = new HeapViewerNode[this.nodesCount + containersOffset];
        for (int i = 0; i < this.nodesCount; ++i) {
            int firstItem = this.getFirstItemIndex(i) + 1;
            int lastItem = this.getLastItemIndex(i) + 1;
            nodes[i + containersOffset] = new ObjectsContainer(this.getNodesContainerString(format.format(firstItem), format.format(lastItem)), i);
        }
        if (containersOffset > 0) {
            nodes[0] = new SampleContainer(this.getSamplesContainerString(format.format(100)), 100);
        }
        return nodes;
    }

    private T getPreviousObject(int containerIndex, Heap heap, HeapViewerNodeFilter viewFilter, DataType dataType, SortOrder sortOrder, Progress progress) throws InterruptedException {
        if (containerIndex <= 0) {
            return this.previousObject;
        }
        T object = this.previousObjects[containerIndex - 1];
        if (object != null) {
            return object;
        }
        int steps = containerIndex - this.lastKnownPreviousObjectIndex - 1;
        int bufferSize = (steps + this.nodesOffset) * 1000;
        if (this.lastKnownPreviousObjectIndex == -1) {
            bufferSize -= this.previousObjectOffset + 1;
        }
        if (bufferSize > 1000000) {
            int bufferIterations = bufferSize / 1000000;
            if (bufferIterations * 1000000 < bufferSize) {
                ++bufferIterations;
            }
            int bufferDelta = steps / bufferIterations;
            Thread worker = Thread.currentThread();
            int lastInstanceIDIndexX = this.lastKnownPreviousObjectIndex;
            for (int i = 1; i <= bufferIterations; ++i) {
                this.getPreviousObject(lastInstanceIDIndexX + bufferDelta * i, heap, viewFilter, dataType, sortOrder, progress);
                if (!worker.isInterrupted()) continue;
                throw new InterruptedException();
            }
            return this.getPreviousObject(containerIndex, heap, viewFilter, dataType, sortOrder, progress);
        }
        object = this.lastKnownPreviousObjectIndex == -1 ? this.previousObject : this.previousObjects[this.lastKnownPreviousObjectIndex];
        SortedObjectsBuffer buffer = new SortedObjectsBuffer<T>(bufferSize, object, dataType, sortOrder, viewFilter, heap, (HeapViewerNode)this.getParent()){

            @Override
            protected boolean sorts(DataType dataType) {
                return MoreObjectsNode.this.sorts(dataType);
            }

            @Override
            protected HeapViewerNode createNode(T object) {
                return MoreObjectsNode.this.createNode(object);
            }
        };
        Iterator<T> objectsIt = this.objectsIterator(0, progress);
        while (objectsIt.hasNext()) {
            buffer.add(objectsIt.next());
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        T[] objects = buffer.getObjects();
        int offset = this.lastKnownPreviousObjectIndex == -1 ? -this.previousObjectOffset - 1 : 0;
        for (int i = 0; i < steps; ++i) {
            int resultsIndex = (i + 1 + this.nodesOffset) * 1000 + offset - 1;
            int updatedIndex = this.lastKnownPreviousObjectIndex + 1 + i;
            this.previousObjects[updatedIndex] = objects[resultsIndex];
        }
        this.lastKnownPreviousObjectIndex = containerIndex - 1;
        return this.previousObjects[containerIndex - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T[] getObjects(int containerIndex, Heap heap, HeapViewerNodeFilter viewFilter, DataType dataType, SortOrder sortOrder, Progress progress) throws InterruptedException {
        T[] objects;
        T object;
        int start = this.getFirstItemIndex(containerIndex);
        int end = this.getLastItemIndex(containerIndex);
        try {
            progress.setupUnknownSteps();
            object = this.getPreviousObject(containerIndex, heap, viewFilter, dataType, sortOrder, progress);
        }
        finally {
            progress.finish();
        }
        SortedObjectsBuffer buffer = new SortedObjectsBuffer<T>(end - start + 1, object, dataType, sortOrder, viewFilter, heap, (HeapViewerNode)this.getParent()){

            @Override
            protected boolean sorts(DataType dataType) {
                return MoreObjectsNode.this.sorts(dataType);
            }

            @Override
            protected HeapViewerNode createNode(T object) {
                return MoreObjectsNode.this.createNode(object);
            }
        };
        try {
            progress.setupKnownSteps(this.iteratorObjectsCount);
            Iterator<T> objectsIt = this.objectsIterator(0, progress);
            while (objectsIt.hasNext()) {
                buffer.add(objectsIt.next());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            objects = buffer.getObjects();
        }
        finally {
            progress.finish();
        }
        if (containerIndex >= 0 && containerIndex < this.nodesCount - 1 && this.previousObjects[containerIndex] == null) {
            this.previousObjects[containerIndex] = objects[objects.length - 1];
            this.lastKnownPreviousObjectIndex = containerIndex;
        }
        return objects;
    }

    private int getFirstItemIndex(int containerIndex) {
        return containerIndex <= 0 ? this.previousObjectOffset + 1 : 1000 * (containerIndex + this.nodesOffset);
    }

    private int getLastItemIndex(int containerIndex) {
        return containerIndex >= 0 && containerIndex < this.nodesCount - 1 ? 1000 * (containerIndex + 1 + this.nodesOffset) - 1 : this.objectsCount - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapViewerNode[] loadChildren(int containerIndex, Progress progress) throws InterruptedException {
        HeapViewerNode[] nodes;
        int start = this.getFirstItemIndex(containerIndex);
        int end = this.getLastItemIndex(containerIndex);
        try {
            progress.setupKnownSteps(end);
            int i = 0;
            nodes = new HeapViewerNode[end - start + 1];
            Iterator<T> objectsIt = this.objectsIterator(start, progress);
            while (i < nodes.length && objectsIt.hasNext()) {
                nodes[i++] = this.createNode(objectsIt.next());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        finally {
            progress.finish();
        }
        return nodes;
    }

    private HeapViewerNode[] computeChildren(int containerIndex, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        DataType dataType;
        SortOrder sortOrder;
        SortOrder sortOrder2 = sortOrder = sortOrders == null || sortOrders.isEmpty() ? null : sortOrders.get(0);
        if (sortOrder == null || sortOrder.equals((Object)SortOrder.UNSORTED)) {
            return this.loadChildren(containerIndex, progress);
        }
        DataType dataType2 = dataType = dataTypes == null || dataTypes.isEmpty() ? null : dataTypes.get(0);
        if (dataType == null || !this.sorts(dataType)) {
            return this.loadChildren(containerIndex, progress);
        }
        T[] objects = this.getObjects(containerIndex, heap, null, dataType, sortOrder, progress);
        Thread worker = Thread.currentThread();
        HeapViewerNode[] nodes = new HeapViewerNode[objects.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.createNode(objects[i]);
            if (!worker.isInterrupted()) continue;
            throw new InterruptedException();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapViewerNode[] computeSampleChildren(int type, int count, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        HeapViewerNode[] nodes;
        int index = 0;
        int step = this.objectsCount / (count - 1);
        try {
            progress.setupKnownSteps(this.iteratorObjectsCount);
            int i = 0;
            Integer[] indexes = new Integer[count];
            if (type == 0) {
                int hitIndex = 0;
                for (int j = 0; j < count; ++j) {
                    indexes[j] = hitIndex;
                    hitIndex = j == count - 2 ? this.objectsCount - 1 : hitIndex + step;
                }
            } else {
                Random r = new Random(type * 7);
                TreeSet<Integer> idSet = new TreeSet<Integer>();
                while (idSet.size() < count) {
                    idSet.add(r.nextInt(this.objectsCount));
                }
                idSet.toArray(indexes);
            }
            nodes = new HeapViewerNode[count];
            Iterator<T> objectsIt = this.objectsIterator(0, progress);
            while (index < count && i < this.objectsCount && objectsIt.hasNext()) {
                T object = objectsIt.next();
                if (i == indexes[index]) {
                    nodes[index++] = this.createNode(object);
                }
                ++i;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        finally {
            progress.finish();
        }
        return nodes;
    }

    private class ObjectsContainer
    extends TextNode {
        private final int containerIndex;

        ObjectsContainer(String text, int containerIndex) {
            super(text);
            this.containerIndex = containerIndex;
            this.resetChildren();
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            return MoreObjectsNode.this.computeChildren(this.containerIndex, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
    }

    private static class ShuffleAction
    extends HeapViewerNodeAction {
        private final SampleContainer node;

        ShuffleAction(SampleContainer node) {
            super(Bundle.MoreObjectsNode_ShuffleAction(), 110);
            this.node = node;
            this.setEnabled(!node.isLeaf());
        }

        @Override
        public boolean isMiddleButtonDefault(ActionEvent e) {
            int modifiers = e.getModifiers();
            return (modifiers & 2) == 2 && (modifiers & 1) != 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.node.incrementType();
        }
    }

    public static class ShuffleActionProvider
    extends HeapViewerNodeAction.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        @Override
        public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            if (node instanceof SampleContainer) {
                return new HeapViewerNodeAction[]{new ShuffleAction((SampleContainer)node)};
            }
            return null;
        }
    }

    private class SampleContainer
    extends TextNode {
        private final int count;
        private int type;

        SampleContainer(String text, int count) {
            super(text);
            this.count = count;
            this.resetChildren();
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            return MoreObjectsNode.this.computeSampleChildren(this.type, this.count, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        }

        void incrementType() {
            ++this.type;
            this.resetChildren();
            RootNode root = RootNode.get(this);
            if (root != null) {
                root.retrieveChildren(this);
                root.updateChildren(root);
            }
        }
    }
}

