/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.results.memory.DiffObjLivenessCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.JMethodIdTable;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjLivenessCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsDiff
extends LivenessMemoryResultsSnapshot {
    private final LivenessMemoryResultsSnapshot snapshot1;
    private final LivenessMemoryResultsSnapshot snapshot2;
    private float[] avgObjectAge;
    private String[] classNames;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] objectsSizePerClass;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int nClasses;
    private long maxTrackedLiveObjectsSizeDiff;
    private long minTrackedLiveObjectsSizeDiff;

    public LivenessMemoryResultsDiff(LivenessMemoryResultsSnapshot snapshot1, LivenessMemoryResultsSnapshot snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
        this.computeDiff(snapshot1, snapshot2);
    }

    @Override
    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public String getClassName(int classId) {
        return this.classNames[classId];
    }

    @Override
    public String[] getClassNames() {
        return this.classNames;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    @Override
    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxTrackedLiveObjectsSizeDiff() {
        return this.maxTrackedLiveObjectsSizeDiff;
    }

    @Override
    public long getMaxValue() {
        return -1L;
    }

    public long getMinTrackedLiveObjectsSizeDiff() {
        return this.minTrackedLiveObjectsSizeDiff;
    }

    @Override
    public int getNAlloc() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNInstrClasses() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNProfiledClasses() {
        return this.nClasses;
    }

    @Override
    public long getNTotalTracked() {
        return -1L;
    }

    @Override
    public long getNTotalTrackedBytes() {
        return -1L;
    }

    @Override
    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    @Override
    public int getNTrackedItems() {
        return this.getNProfiledClasses();
    }

    @Override
    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    @Override
    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    @Override
    public boolean containsStacks() {
        return false;
    }

    @Override
    public PresoObjLivenessCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        int selectId1 = this.classId1(classId);
        int selectId2 = this.classId2(classId);
        PresoObjLivenessCCTNode node1 = null;
        PresoObjLivenessCCTNode node2 = null;
        if (selectId1 != -1) {
            node1 = this.snapshot1.createPresentationCCT(selectId1, dontShowZeroLiveObjAllocPaths);
        }
        if (selectId2 != -1) {
            node2 = this.snapshot2.createPresentationCCT(selectId2, dontShowZeroLiveObjAllocPaths);
        }
        return new DiffObjLivenessCCTNode(node1, node2);
    }

    @Override
    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjLivenessCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        int selectId1 = this.classId1(classId);
        int selectId2 = this.classId2(classId);
        PresoObjLivenessCCTNode node1 = null;
        PresoObjLivenessCCTNode node2 = null;
        if (selectId1 != -1) {
            node1 = this.snapshot1.createPresentationCCT(rootNode, selectId1, dontShowZeroLiveObjAllocPaths);
        }
        if (selectId2 != -1) {
            node2 = this.snapshot2.createPresentationCCT(rootNode, selectId2, dontShowZeroLiveObjAllocPaths);
        }
        return new DiffObjLivenessCCTNode(node1, node2);
    }

    private int classId1(int classId) {
        return this.classId(classId, this.snapshot1);
    }

    private int classId2(int classId) {
        return this.classId(classId, this.snapshot2);
    }

    private int classId(int classId, LivenessMemoryResultsSnapshot snapshot) {
        if (snapshot == null) {
            return -1;
        }
        String className = this.getClassName(classId);
        String[] classNames = snapshot.getClassNames();
        if (classNames == null) {
            return -1;
        }
        for (int i = 0; i < classNames.length; ++i) {
            if (!classNames[i].equals(className)) continue;
            return i;
        }
        return -1;
    }

    private void computeDiff(LivenessMemoryResultsSnapshot snapshot1, LivenessMemoryResultsSnapshot snapshot2) {
        int s1nClasses = snapshot1.getNTrackedItems();
        int s2nClasses = snapshot2.getNTrackedItems();
        HashMap<String, Integer> classNamesIdxMap = new HashMap<String, Integer>(s1nClasses);
        ArrayList<Long> nTrackedAllocObjectsArr = new ArrayList<Long>(s1nClasses);
        ArrayList<Long> objectsSizePerClassArr = new ArrayList<Long>(s1nClasses);
        ArrayList<Integer> nTrackedLiveObjectsArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Integer> maxSurvGenArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Float> avgObjectAgeArr = new ArrayList<Float>(s1nClasses);
        ArrayList<Long> trackedLiveObjectsSizeArr = new ArrayList<Long>(s1nClasses);
        ArrayList<Integer> nTotalAllocObjectsArr = new ArrayList<Integer>(s1nClasses);
        String[] s1ClassNames = snapshot1.getClassNames();
        long[] s1NTrackedAllocObjects = snapshot1.getNTrackedAllocObjects();
        long[] s1ObjectsSizePerClass = snapshot1.getObjectsSizePerClass();
        int[] s1NTrackedLiveObjects = snapshot1.getNTrackedLiveObjects();
        int[] s1MaxSurvGen = snapshot1.getMaxSurvGen();
        float[] s1AvgObjectAge = snapshot1.getAvgObjectAge();
        long[] s1TrackedLiveObjectsSize = snapshot1.getTrackedLiveObjectsSize();
        int[] s1NTotalAllocObjects = snapshot1.getnTotalAllocObjects();
        int idx = 0;
        for (int i = 0; i < s1nClasses; ++i) {
            Integer classIdx = (Integer)classNamesIdxMap.get(s1ClassNames[i]);
            if (classIdx != null) {
                nTrackedAllocObjectsArr.set(classIdx, (Long)nTrackedAllocObjectsArr.get(classIdx) - s1NTrackedAllocObjects[i]);
                objectsSizePerClassArr.set(classIdx, (Long)objectsSizePerClassArr.get(classIdx) - s1ObjectsSizePerClass[i]);
                nTrackedLiveObjectsArr.set(classIdx, (Integer)nTrackedLiveObjectsArr.get(classIdx) - s1NTrackedLiveObjects[i]);
                maxSurvGenArr.set(classIdx, (Integer)maxSurvGenArr.get(classIdx) - s1MaxSurvGen[i]);
                avgObjectAgeArr.set(classIdx, Float.valueOf(((Float)avgObjectAgeArr.get(classIdx)).floatValue() - s1AvgObjectAge[i]));
                trackedLiveObjectsSizeArr.set(classIdx, (Long)trackedLiveObjectsSizeArr.get(classIdx) - s1TrackedLiveObjectsSize[i]);
                nTotalAllocObjectsArr.set(classIdx, (Integer)nTotalAllocObjectsArr.get(classIdx) - s1NTotalAllocObjects[i]);
                continue;
            }
            classNamesIdxMap.put(s1ClassNames[i], idx++);
            nTrackedAllocObjectsArr.add(-s1NTrackedAllocObjects[i]);
            objectsSizePerClassArr.add(-s1ObjectsSizePerClass[i]);
            nTrackedLiveObjectsArr.add(-s1NTrackedLiveObjects[i]);
            maxSurvGenArr.add(-s1MaxSurvGen[i]);
            avgObjectAgeArr.add(Float.valueOf(-s1AvgObjectAge[i]));
            trackedLiveObjectsSizeArr.add(-s1TrackedLiveObjectsSize[i]);
            nTotalAllocObjectsArr.add(-s1NTotalAllocObjects[i]);
        }
        String[] s2ClassNames = snapshot2.getClassNames();
        long[] s2NTrackedAllocObjects = snapshot2.getNTrackedAllocObjects();
        long[] s2ObjectsSizePerClass = snapshot2.getObjectsSizePerClass();
        int[] s2NTrackedLiveObjects = snapshot2.getNTrackedLiveObjects();
        int[] s2MaxSurvGen = snapshot2.getMaxSurvGen();
        float[] s2AvgObjectAge = snapshot2.getAvgObjectAge();
        long[] s2TrackedLiveObjectsSize = snapshot2.getTrackedLiveObjectsSize();
        int[] s2NTotalAllocObjects = snapshot2.getnTotalAllocObjects();
        for (int i = 0; i < s2nClasses; ++i) {
            Integer classIdx = (Integer)classNamesIdxMap.get(s2ClassNames[i]);
            if (classIdx != null) {
                nTrackedAllocObjectsArr.set(classIdx, (Long)nTrackedAllocObjectsArr.get(classIdx) + s2NTrackedAllocObjects[i]);
                objectsSizePerClassArr.set(classIdx, (Long)objectsSizePerClassArr.get(classIdx) + s2ObjectsSizePerClass[i]);
                nTrackedLiveObjectsArr.set(classIdx, (Integer)nTrackedLiveObjectsArr.get(classIdx) + s2NTrackedLiveObjects[i]);
                maxSurvGenArr.set(classIdx, (Integer)maxSurvGenArr.get(classIdx) + s2MaxSurvGen[i]);
                avgObjectAgeArr.set(classIdx, Float.valueOf(((Float)avgObjectAgeArr.get(classIdx)).floatValue() + s2AvgObjectAge[i]));
                trackedLiveObjectsSizeArr.set(classIdx, (Long)trackedLiveObjectsSizeArr.get(classIdx) + s2TrackedLiveObjectsSize[i]);
                nTotalAllocObjectsArr.set(classIdx, (Integer)nTotalAllocObjectsArr.get(classIdx) + s2NTotalAllocObjects[i]);
                continue;
            }
            classNamesIdxMap.put(s2ClassNames[i], nTrackedAllocObjectsArr.size());
            nTrackedAllocObjectsArr.add(s2NTrackedAllocObjects[i]);
            objectsSizePerClassArr.add(s2ObjectsSizePerClass[i]);
            nTrackedLiveObjectsArr.add(s2NTrackedLiveObjects[i]);
            maxSurvGenArr.add(s2MaxSurvGen[i]);
            avgObjectAgeArr.add(Float.valueOf(s2AvgObjectAge[i]));
            trackedLiveObjectsSizeArr.add(s2TrackedLiveObjectsSize[i]);
            nTotalAllocObjectsArr.add(s2NTotalAllocObjects[i]);
        }
        this.nClasses = classNamesIdxMap.size();
        this.classNames = new String[this.nClasses];
        this.nTrackedAllocObjects = new long[this.nClasses];
        this.objectsSizePerClass = new long[this.nClasses];
        this.nTrackedLiveObjects = new int[this.nClasses];
        this.maxSurvGen = new int[this.nClasses];
        this.avgObjectAge = new float[this.nClasses];
        this.trackedLiveObjectsSize = new long[this.nClasses];
        this.nTotalAllocObjects = new int[this.nClasses];
        this.minTrackedLiveObjectsSizeDiff = Integer.MAX_VALUE;
        this.maxTrackedLiveObjectsSizeDiff = Integer.MIN_VALUE;
        Iterator classNamesIter = classNamesIdxMap.entrySet().iterator();
        int index = 0;
        while (classNamesIter.hasNext()) {
            Map.Entry entry = classNamesIter.next();
            int classIndex = (Integer)entry.getValue();
            this.classNames[index] = (String)entry.getKey();
            this.nTrackedAllocObjects[index] = (Long)nTrackedAllocObjectsArr.get(classIndex);
            this.objectsSizePerClass[index] = (Long)objectsSizePerClassArr.get(classIndex);
            this.nTrackedLiveObjects[index] = (Integer)nTrackedLiveObjectsArr.get(classIndex);
            this.maxSurvGen[index] = (Integer)maxSurvGenArr.get(classIndex);
            this.avgObjectAge[index] = ((Float)avgObjectAgeArr.get(classIndex)).floatValue();
            this.trackedLiveObjectsSize[index] = (Long)trackedLiveObjectsSizeArr.get(classIndex);
            this.nTotalAllocObjects[index] = (Integer)nTotalAllocObjectsArr.get(classIndex);
            this.minTrackedLiveObjectsSizeDiff = Math.min(this.minTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[index]);
            this.maxTrackedLiveObjectsSizeDiff = Math.max(this.maxTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[index]);
            ++index;
        }
        if (this.minTrackedLiveObjectsSizeDiff > 0L && this.maxTrackedLiveObjectsSizeDiff > 0L) {
            this.minTrackedLiveObjectsSizeDiff = 0L;
        } else if (this.minTrackedLiveObjectsSizeDiff < 0L && this.maxTrackedLiveObjectsSizeDiff < 0L) {
            this.maxTrackedLiveObjectsSizeDiff = 0L;
        }
    }
}

