/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PWDProtectExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.siv.SivMode;

public class PWDProtectExtensionPreparator
extends ExtensionPreparator<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDProtectExtensionMessage msg;

    public PWDProtectExtensionPreparator(Chooser chooser, PWDProtectExtensionMessage message, PWDProtectExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PWDProtectExtension");
        try {
            this.prepareUsername(this.msg);
        }
        catch (CryptoException e) {
            throw new PreparationException("Failed to encrypt username", e);
        }
        this.prepareUsernameLength(this.msg);
    }

    private void prepareUsername(PWDProtectExtensionMessage msg) throws CryptoException {
        HKDFAlgorithm hkdfAlgorithm;
        Config config = this.chooser.getConfig();
        EllipticCurve curve = CurveFactory.getCurve(config.getDefaultPWDProtectGroup());
        Point generator = curve.getBasePoint();
        Point serverPublicKey = config.getDefaultServerPWDProtectPublicKey();
        if (curve.getModulus().bitLength() <= 256) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA256;
        } else if (curve.getModulus().bitLength() <= 384) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA384;
        } else {
            throw new CryptoException("Missing HKDF algorithm for curves larger than 384 bits");
        }
        BigInteger clientPublicKey = curve.mult(config.getDefaultServerPWDProtectRandomSecret(), generator).getX().getData();
        BigInteger sharedSecret = curve.mult(config.getDefaultServerPWDProtectRandomSecret(), serverPublicKey).getX().getData();
        byte[] key = HKDFunction.expand(hkdfAlgorithm, HKDFunction.extract(hkdfAlgorithm, null, ArrayConverter.bigIntegerToByteArray((BigInteger)sharedSecret)), new byte[0], curve.getModulus().bitLength() / 8);
        LOGGER.debug("Username encryption key: " + ArrayConverter.bytesToHexString((byte[])key));
        byte[] ctrKey = Arrays.copyOfRange(key, 0, key.length / 2);
        byte[] macKey = Arrays.copyOfRange(key, key.length / 2, key.length);
        SivMode AES_SIV = new SivMode();
        byte[] protectedUsername = AES_SIV.encrypt(ctrKey, macKey, this.chooser.getClientPWDUsername().getBytes(), (byte[][])new byte[0][]);
        msg.setUsername(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.bigIntegerToByteArray((BigInteger)clientPublicKey, (int)(curve.getModulus().bitLength() / 8), (boolean)true), protectedUsername}));
        LOGGER.debug("Username: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getUsername()));
    }

    private void prepareUsernameLength(PWDProtectExtensionMessage msg) {
        msg.setUsernameLength(((byte[])msg.getUsername().getValue()).length);
        LOGGER.debug("UsernameLength: " + msg.getUsernameLength().getValue());
    }
}

