/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.IndexerAbortQuery;
import org.lwjgl.llvm.IndexerDiagnostic;
import org.lwjgl.llvm.IndexerEnteredMainFile;
import org.lwjgl.llvm.IndexerImportedASTFile;
import org.lwjgl.llvm.IndexerIncludedFile;
import org.lwjgl.llvm.IndexerIndexDeclaration;
import org.lwjgl.llvm.IndexerIndexEntityReference;
import org.lwjgl.llvm.IndexerStartedTranslationUnit;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class IndexerCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ABORTQUERY;
    public static final int DIAGNOSTIC;
    public static final int ENTEREDMAINFILE;
    public static final int PPINCLUDEDFILE;
    public static final int IMPORTEDASTFILE;
    public static final int STARTEDTRANSLATIONUNIT;
    public static final int INDEXDECLARATION;
    public static final int INDEXENTITYREFERENCE;

    public IndexerCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), IndexerCallbacks.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int (*) (CXClientData, void *)")
    public IndexerAbortQuery abortQuery() {
        return IndexerCallbacks.nabortQuery(this.address());
    }

    @NativeType(value="void (*) (CXClientData, CXDiagnosticSet, void *)")
    public IndexerDiagnostic diagnostic() {
        return IndexerCallbacks.ndiagnostic(this.address());
    }

    @NativeType(value="CXIdxClientFile (*) (CXClientData, CXFile, void *)")
    public IndexerEnteredMainFile enteredMainFile() {
        return IndexerCallbacks.nenteredMainFile(this.address());
    }

    @NativeType(value="CXIdxClientFile (*) (CXClientData, CXIdxIncludedFileInfo const *)")
    public IndexerIncludedFile ppIncludedFile() {
        return IndexerCallbacks.nppIncludedFile(this.address());
    }

    @NativeType(value="CXIdxClientASTFile (*) (CXClientData, CXIdxImportedASTFileInfo const *)")
    public IndexerImportedASTFile importedASTFile() {
        return IndexerCallbacks.nimportedASTFile(this.address());
    }

    @NativeType(value="CXIdxClientContainer (*) (CXClientData, void *)")
    public IndexerStartedTranslationUnit startedTranslationUnit() {
        return IndexerCallbacks.nstartedTranslationUnit(this.address());
    }

    @NativeType(value="void (*) (CXClientData, CXIdxDeclInfo const *)")
    public IndexerIndexDeclaration indexDeclaration() {
        return IndexerCallbacks.nindexDeclaration(this.address());
    }

    @NativeType(value="void (*) (CXClientData, CXIdxEntityRefInfo const *)")
    public IndexerIndexEntityReference indexEntityReference() {
        return IndexerCallbacks.nindexEntityReference(this.address());
    }

    public static IndexerCallbacks malloc() {
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static IndexerCallbacks calloc() {
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static IndexerCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static IndexerCallbacks create(long address) {
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)address);
    }

    @Nullable
    public static IndexerCallbacks createSafe(long address) {
        return address == 0L ? null : (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)IndexerCallbacks.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = IndexerCallbacks.__create((int)capacity, (int)SIZEOF);
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static IndexerCallbacks mallocStack() {
        return IndexerCallbacks.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static IndexerCallbacks callocStack() {
        return IndexerCallbacks.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static IndexerCallbacks mallocStack(MemoryStack stack) {
        return IndexerCallbacks.malloc(stack);
    }

    @Deprecated
    public static IndexerCallbacks callocStack(MemoryStack stack) {
        return IndexerCallbacks.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return IndexerCallbacks.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return IndexerCallbacks.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return IndexerCallbacks.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return IndexerCallbacks.calloc(capacity, stack);
    }

    public static IndexerCallbacks malloc(MemoryStack stack) {
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IndexerCallbacks calloc(MemoryStack stack) {
        return (IndexerCallbacks)IndexerCallbacks.wrap(IndexerCallbacks.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)IndexerCallbacks.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static IndexerAbortQuery nabortQuery(long struct) {
        return IndexerAbortQuery.create(MemoryUtil.memGetAddress((long)(struct + (long)ABORTQUERY)));
    }

    public static IndexerDiagnostic ndiagnostic(long struct) {
        return IndexerDiagnostic.create(MemoryUtil.memGetAddress((long)(struct + (long)DIAGNOSTIC)));
    }

    public static IndexerEnteredMainFile nenteredMainFile(long struct) {
        return IndexerEnteredMainFile.create(MemoryUtil.memGetAddress((long)(struct + (long)ENTEREDMAINFILE)));
    }

    public static IndexerIncludedFile nppIncludedFile(long struct) {
        return IndexerIncludedFile.create(MemoryUtil.memGetAddress((long)(struct + (long)PPINCLUDEDFILE)));
    }

    public static IndexerImportedASTFile nimportedASTFile(long struct) {
        return IndexerImportedASTFile.create(MemoryUtil.memGetAddress((long)(struct + (long)IMPORTEDASTFILE)));
    }

    public static IndexerStartedTranslationUnit nstartedTranslationUnit(long struct) {
        return IndexerStartedTranslationUnit.create(MemoryUtil.memGetAddress((long)(struct + (long)STARTEDTRANSLATIONUNIT)));
    }

    public static IndexerIndexDeclaration nindexDeclaration(long struct) {
        return IndexerIndexDeclaration.create(MemoryUtil.memGetAddress((long)(struct + (long)INDEXDECLARATION)));
    }

    public static IndexerIndexEntityReference nindexEntityReference(long struct) {
        return IndexerIndexEntityReference.create(MemoryUtil.memGetAddress((long)(struct + (long)INDEXENTITYREFERENCE)));
    }

    static {
        Struct.Layout layout = IndexerCallbacks.__struct((Struct.Member[])new Struct.Member[]{IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE), IndexerCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ABORTQUERY = layout.offsetof(0);
        DIAGNOSTIC = layout.offsetof(1);
        ENTEREDMAINFILE = layout.offsetof(2);
        PPINCLUDEDFILE = layout.offsetof(3);
        IMPORTEDASTFILE = layout.offsetof(4);
        STARTEDTRANSLATIONUNIT = layout.offsetof(5);
        INDEXDECLARATION = layout.offsetof(6);
        INDEXENTITYREFERENCE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<IndexerCallbacks, Buffer>
    implements NativeResource {
        private static final IndexerCallbacks ELEMENT_FACTORY = IndexerCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected IndexerCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int (*) (CXClientData, void *)")
        public IndexerAbortQuery abortQuery() {
            return IndexerCallbacks.nabortQuery(this.address());
        }

        @NativeType(value="void (*) (CXClientData, CXDiagnosticSet, void *)")
        public IndexerDiagnostic diagnostic() {
            return IndexerCallbacks.ndiagnostic(this.address());
        }

        @NativeType(value="CXIdxClientFile (*) (CXClientData, CXFile, void *)")
        public IndexerEnteredMainFile enteredMainFile() {
            return IndexerCallbacks.nenteredMainFile(this.address());
        }

        @NativeType(value="CXIdxClientFile (*) (CXClientData, CXIdxIncludedFileInfo const *)")
        public IndexerIncludedFile ppIncludedFile() {
            return IndexerCallbacks.nppIncludedFile(this.address());
        }

        @NativeType(value="CXIdxClientASTFile (*) (CXClientData, CXIdxImportedASTFileInfo const *)")
        public IndexerImportedASTFile importedASTFile() {
            return IndexerCallbacks.nimportedASTFile(this.address());
        }

        @NativeType(value="CXIdxClientContainer (*) (CXClientData, void *)")
        public IndexerStartedTranslationUnit startedTranslationUnit() {
            return IndexerCallbacks.nstartedTranslationUnit(this.address());
        }

        @NativeType(value="void (*) (CXClientData, CXIdxDeclInfo const *)")
        public IndexerIndexDeclaration indexDeclaration() {
            return IndexerCallbacks.nindexDeclaration(this.address());
        }

        @NativeType(value="void (*) (CXClientData, CXIdxEntityRefInfo const *)")
        public IndexerIndexEntityReference indexEntityReference() {
            return IndexerCallbacks.nindexEntityReference(this.address());
        }
    }
}

