/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.HeaderParser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class JHelpPrintHandler
implements ActionListener {
    protected HelpModel model;
    protected Component comp;
    protected Component psComp;
    protected Document document;
    protected Dimension size;
    static MyJEditorPane editor = new MyJEditorPane();
    private Hashtable kitRegistry;
    private Hashtable typeHandlers;
    private String charSetName = "8859_1";
    private EditorKit kit;
    transient RootView rootview = new RootView();
    private static boolean debug = false;

    public JHelpPrintHandler(HelpModel helpModel, Component component) {
        this.model = helpModel;
        this.comp = component;
        this.document = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = this.comp;
        while (component != null) {
            if (component instanceof Frame) break;
            component = component.getParent();
        }
        if (component == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob((Frame)component, null, null);
        if (printJob != null) {
            Dimension dimension = printJob.getPageDimension();
            this.size = new Dimension(dimension.width - 144, dimension.height - 144);
            this.print1_1(printJob);
        }
    }

    private EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        if (this.kitRegistry == null) {
            this.kitRegistry = new Hashtable();
        } else {
            editorKit = (EditorKit)this.kitRegistry.get(string);
        }
        if (editorKit == null) {
            HelpSet helpSet = this.model.getHelpSet();
            String string2 = (String)helpSet.getKeyData(HelpSet.kitTypeRegistry, string);
            if (string2 == null) {
                return null;
            }
            ClassLoader classLoader = (ClassLoader)helpSet.getKeyData(HelpSet.kitLoaderRegistry, string);
            if (classLoader == null) {
                classLoader = helpSet.getLoader();
            }
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                editorKit = (EditorKit)clazz.newInstance();
                this.kitRegistry.put(string, editorKit);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        editorKit = JEditorPane.createEditorKitForContentType(string);
        return editorKit;
    }

    protected void createView() {
        ViewFactory viewFactory = this.kit.getViewFactory();
        Element element = this.document.getDefaultRootElement();
        this.rootview.setView(viewFactory.create(element));
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("JHelpPrintHandler: " + string);
        }
    }

    private final EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.getEditorKitForContentType("text/plain");
        }
        return this.kit;
    }

    private EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = this.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = new DefaultEditorKit();
        }
        return editorKit;
    }

    private URL getPage() {
        if (this.document != null) {
            return (URL)this.document.getProperty("stream");
        }
        return null;
    }

    private InputStream getStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        String string = uRLConnection.getContentType();
        if (string != null) {
            this.setContentType(string);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    protected Rectangle getViewRect() {
        Dimension dimension = new Dimension();
        dimension.width = (int)Math.max((long)this.rootview.getMinimumSpan(0), (long)this.size.width);
        dimension.height = (int)Math.min((long)this.rootview.getPreferredSpan(1), Integer.MAX_VALUE);
        Rectangle rectangle = new Rectangle(dimension);
        return rectangle;
    }

    public void handlePageSetup(Component component) {
        this.psComp = component;
    }

    private void print1_1(PrintJob printJob) {
        this.setDocument();
        if (this.document == null) {
            return;
        }
        this.createView();
        Print1dot1 print1dot1 = new Print1dot1(printJob, this.rootview);
        print1dot1.start();
    }

    void read(InputStream inputStream, Document document) throws IOException {
        try {
            this.kit.read(new InputStreamReader(inputStream, this.charSetName), document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.charSetName = string;
            } else {
                this.setCharsetFromContentTypeParameters(string);
            }
            inputStream.close();
            URL uRL = (URL)document.getProperty("stream");
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {}
            document.putProperty("IgnoreCharsetDirective", new Boolean(true));
            this.read(inputStream, document);
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0) {
                HeaderParser headerParser = new HeaderParser(string);
                this.charSetName = string2 = headerParser.findValue("charset");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public final void setContentType(String string) {
        Object object;
        int n = string.indexOf(";");
        if (n > -1) {
            object = string.substring(n);
            if ((string = string.substring(0, n).trim()).toLowerCase().startsWith("text/")) {
                this.setCharsetFromContentTypeParameters((String)object);
            }
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (object = this.getEditorKitForContentType(string)) == null)) {
            this.setEditorKit((EditorKit)object);
        }
    }

    protected void setDocument() {
        URL uRL = this.model.getCurrentURL();
        if (uRL == null) {
            this.document = null;
            return;
        }
        try {
            this.document = this.setPage(uRL);
        }
        catch (IOException iOException) {
            this.document = null;
        }
    }

    private void setEditorKit(EditorKit editorKit) {
        this.kit = editorKit;
        if (this.kit != null) {
            this.document = this.kit.createDefaultDocument();
        }
    }

    private void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    private Document setPage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        if (uRL2 == null || !uRL2.sameFile(uRL)) {
            InputStream inputStream = this.getStream(uRL);
            if (this.kit != null) {
                Document document = this.kit.createDefaultDocument();
                document.putProperty("stream", uRL);
                this.read(inputStream, document);
                return document;
            }
        } else if (uRL2 != null && uRL2.sameFile(uRL)) {
            return this.document;
        }
        return null;
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Container getContainer() {
            if (editor == null) {
                editor = new MyJEditorPane();
            }
            return editor;
        }

        public Document getDocument() {
            return JHelpPrintHandler.this.document;
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return JHelpPrintHandler.this.document.getDefaultRootElement();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            return 1;
        }

        public ViewFactory getViewFactory() {
            ViewFactory viewFactory = JHelpPrintHandler.this.kit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return null;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }
    }

    class Print1dot1
    extends Thread {
        PrintJob pjob;
        RootView rootview;

        Print1dot1(PrintJob printJob, RootView rootView) {
            this.pjob = printJob;
            this.rootview = rootView;
            this.setDaemon(true);
        }

        public void render1_1() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Rectangle rectangle = new Rectangle(JHelpPrintHandler.this.size.width, JHelpPrintHandler.this.size.height);
            JHelpPrintHandler.debug("printRec " + rectangle);
            Position.Bias[] biasArray = new Position.Bias[1];
            Dimension dimension = new Dimension();
            dimension.width = (int)Math.min((long)this.rootview.getPreferredSpan(0), (long)JHelpPrintHandler.this.size.width);
            dimension.height = (int)Math.min((long)this.rootview.getPreferredSpan(1), Integer.MAX_VALUE);
            this.rootview.setSize(dimension.width, dimension.height);
            Rectangle rectangle2 = JHelpPrintHandler.this.getViewRect();
            Document document = this.rootview.getDocument();
            int n4 = document.getEndPosition().getOffset();
            while (true) {
                Graphics graphics = this.pjob.getGraphics();
                int n5 = rectangle.height + n;
                int n6 = this.rootview.viewToModel(0.0f, rectangle.height + n, rectangle2, biasArray);
                JHelpPrintHandler.debug("point=" + n6);
                try {
                    Shape shape = this.rootview.modelToView(n6, rectangle2, biasArray[0]);
                    Rectangle rectangle3 = shape.getBounds();
                    n3 = n == 0 ? 0 : n;
                    n2 = rectangle3.y - 1;
                    JHelpPrintHandler.debug("Starting height=" + n2);
                    if (rectangle.height + n >= rectangle3.y + rectangle3.height) {
                        n2 = rectangle3.y + rectangle3.height - 1;
                        JHelpPrintHandler.debug("Adjusted height=" + n2);
                    }
                    int n7 = rectangle3.y;
                    int n8 = rectangle3.y + rectangle3.height - 1;
                    int n9 = rectangle3.x + 20;
                    int n10 = 0;
                    int n11 = 0;
                    Rectangle rectangle4 = rectangle3;
                    while (n9 <= JHelpPrintHandler.this.size.width) {
                        int n12 = this.rootview.viewToModel(n9, n5, rectangle2, biasArray);
                        Shape shape2 = this.rootview.modelToView(n12, rectangle2, biasArray[0]);
                        Rectangle rectangle5 = shape2.getBounds();
                        if (rectangle4.equals(rectangle5) || rectangle5.x < n9) {
                            n9 += 20;
                            continue;
                        }
                        JHelpPrintHandler.debug("pointRec2=" + rectangle5);
                        n10 = rectangle5.y;
                        n11 = rectangle5.y + rectangle5.height - 1;
                        if (n11 > n7) {
                            if (n11 > n8) {
                                if (n11 < n5) {
                                    n2 = n11;
                                    n8 = n11;
                                    if (n10 < n7) {
                                        n7 = n10;
                                    }
                                    JHelpPrintHandler.debug("Adjust height to testheight " + n2);
                                } else if (n10 > n8) {
                                    n2 = n10 - 1;
                                    n8 = n11;
                                    n7 = n10;
                                    JHelpPrintHandler.debug("new base component " + n2);
                                } else if (n10 < n7) {
                                    n2 = n10 - 1;
                                    n7 = n10;
                                    n8 = n11;
                                    JHelpPrintHandler.debug("test height > maxheight. Adjust height testY - 1 " + n2);
                                } else {
                                    n2 = n7 - 1;
                                    n8 = n11;
                                    JHelpPrintHandler.debug("test height > maxheight. Adjust height baseY - 1 " + n2);
                                }
                            } else if (n8 < n5) {
                                n2 = n8;
                                if (n10 < n7) {
                                    n7 = n10;
                                }
                                JHelpPrintHandler.debug("baseHeight ok " + n2);
                            } else if (n7 <= n10) {
                                n2 = n7 - 1;
                                JHelpPrintHandler.debug("baseHeight too long - height ok" + n2);
                            } else {
                                n2 = n10 - 1;
                                n7 = n10;
                                JHelpPrintHandler.debug("baseHeight too long - use testY -1 " + n2);
                            }
                        }
                        rectangle4 = rectangle5;
                        n9 = rectangle4.x + 20;
                    }
                    graphics.translate(72, -n3 + 72);
                    graphics.clipRect(0, n3, rectangle.width, n2 - n3);
                    JHelpPrintHandler.debug("printing pg clip=" + graphics.getClip());
                    this.rootview.paint(graphics, rectangle2);
                    graphics.dispose();
                    n = n2 + 1;
                    JHelpPrintHandler.debug("Setting curHeight=" + n + " viewRec=" + rectangle2 + "\n");
                    if (n < rectangle2.height && n6 != n4 - 1) continue;
                }
                catch (BadLocationException badLocationException) {
                    continue;
                }
                break;
            }
        }

        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.render1_1();
            this.pjob.end();
        }
    }

    static class MyJEditorPane
    extends JEditorPane {
        Graphics graphics;

        public MyJEditorPane() {
            this.setDoubleBuffered(false);
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public void setGraphics(Graphics graphics) {
            this.graphics = graphics;
        }
    }
}

