/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class PCanvas
extends JComponent
implements PComponent {
    public static final String INTERATING_CHANGED_NOTIFICATION = "INTERATING_CHANGED_NOTIFICATION";
    public static PCanvas CURRENT_ZCANVAS = null;
    private PCamera camera;
    private PStack cursorStack;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private PPanEventHandler panEventHandler;
    private PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private MouseListener mouseListener;
    private KeyListener keyListener;
    private MouseWheelListener mouseWheelListener;
    private MouseMotionListener mouseMotionListener;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;

    public PCanvas() {
        CURRENT_ZCANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createDefaultCamera());
        this.installInputSources();
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.setPanEventHandler(new PPanEventHandler());
        this.setZoomEventHandler(new PZoomEventHandler());
        this.setBackground(Color.WHITE);
    }

    protected PCamera createDefaultCamera() {
        return PUtil.createBasicScenegraph();
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public void setPanEventHandler(PPanEventHandler pPanEventHandler) {
        if (this.panEventHandler != null) {
            this.removeInputEventListener(this.panEventHandler);
        }
        this.panEventHandler = pPanEventHandler;
        if (this.panEventHandler != null) {
            this.addInputEventListener(this.panEventHandler);
        }
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setZoomEventHandler(PZoomEventHandler pZoomEventHandler) {
        if (this.zoomEventHandler != null) {
            this.removeInputEventListener(this.zoomEventHandler);
        }
        this.zoomEventHandler = pZoomEventHandler;
        if (this.zoomEventHandler != null) {
            this.addInputEventListener(this.zoomEventHandler);
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera pCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = pCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            this.camera.setBounds(this.getBounds());
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().addInputEventListener(pInputEventListener);
    }

    public void removeInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().removeInputEventListener(pInputEventListener);
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean bl) {
        boolean bl2 = this.getInteracting();
        this.interacting = bl ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            int n = this.defaultRenderQuality;
            if (this.getAnimating()) {
                n = this.animatingRenderQuality;
            }
            if (n > this.interactingRenderQuality) {
                this.repaint();
            }
        }
        if (bl2 != (bl = this.getInteracting())) {
            this.firePropertyChange(INTERATING_CHANGED_NOTIFICATION, bl2, bl);
        }
    }

    public void setDefaultRenderQuality(int n) {
        this.defaultRenderQuality = n;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int n) {
        this.animatingRenderQuality = n;
        if (this.getAnimating()) {
            this.repaint();
        }
    }

    public void setInteractingRenderQuality(int n) {
        this.interactingRenderQuality = n;
        if (this.getInteracting()) {
            this.repaint();
        }
    }

    public void pushCursor(Cursor cursor) {
        this.cursorStack.push(this.getCursor());
        this.setCursor(cursor);
    }

    public void popCursor() {
        this.setCursor((Cursor)this.cursorStack.pop());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isEnabled()) {
            this.installInputSources();
        } else {
            this.removeInputSources();
        }
    }

    protected void installInputSources() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 500);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    MouseEvent mouseEvent2 = null;
                    mouseEvent2 = (mouseEvent.getModifiersEx() & 0x1C00) != 0 ? new MouseEvent((Component)mouseEvent.getSource(), 506, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()) : new MouseEvent((Component)mouseEvent.getSource(), 503, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 504);
                    PCanvas.this.sendInputEventToInputManager(mouseEvent2, mouseEvent2.getID());
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    MouseEvent mouseEvent2 = null;
                    mouseEvent2 = (mouseEvent.getModifiersEx() & 0x1C00) != 0 ? new MouseEvent((Component)mouseEvent.getSource(), 506, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()) : new MouseEvent((Component)mouseEvent.getSource(), 503, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    PCanvas.this.sendInputEventToInputManager(mouseEvent2, mouseEvent2.getID());
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 505);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    PCanvas.this.requestFocus();
                    boolean bl = false;
                    if (mouseEvent.getButton() == 0) {
                        if ((mouseEvent.getModifiers() & 0x10) == 16) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 1);
                        } else if ((mouseEvent.getModifiers() & 8) == 8) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 2);
                        } else if ((mouseEvent.getModifiers() & 4) == 4) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 3);
                        }
                    }
                    switch (mouseEvent.getButton()) {
                        case 1: {
                            if (PCanvas.this.isButton1Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton1Pressed = true;
                            break;
                        }
                        case 2: {
                            if (PCanvas.this.isButton2Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton2Pressed = true;
                            break;
                        }
                        case 3: {
                            if (PCanvas.this.isButton3Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton3Pressed = true;
                        }
                    }
                    if (bl) {
                        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                        PCanvas.this.sendInputEventToInputManager(mouseEvent2, 502);
                    }
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 501);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    boolean bl = false;
                    if (mouseEvent.getButton() == 0) {
                        if ((mouseEvent.getModifiers() & 0x10) == 16) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 1);
                        } else if ((mouseEvent.getModifiers() & 8) == 8) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 2);
                        } else if ((mouseEvent.getModifiers() & 4) == 4) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 3);
                        }
                    }
                    switch (mouseEvent.getButton()) {
                        case 1: {
                            if (!PCanvas.this.isButton1Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton1Pressed = false;
                            break;
                        }
                        case 2: {
                            if (!PCanvas.this.isButton2Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton2Pressed = false;
                            break;
                        }
                        case 3: {
                            if (!PCanvas.this.isButton3Pressed) {
                                bl = true;
                            }
                            PCanvas.this.isButton3Pressed = false;
                        }
                    }
                    if (bl) {
                        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                        PCanvas.this.sendInputEventToInputManager(mouseEvent2, 501);
                    }
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 502);
                }
            };
            this.addMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionListener(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 506);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    PCanvas.this.sendInputEventToInputManager(mouseEvent, 503);
                }
            };
            this.addMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    PCanvas.this.sendInputEventToInputManager(mouseWheelEvent, mouseWheelEvent.getScrollType());
                    if (!mouseWheelEvent.isConsumed() && PCanvas.this.getParent() != null) {
                        PCanvas.this.getParent().dispatchEvent(mouseWheelEvent);
                    }
                }
            };
            this.addMouseWheelListener(this.mouseWheelListener);
        }
        if (this.keyListener == null) {
            this.keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    PCanvas.this.sendInputEventToInputManager(keyEvent, 401);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    PCanvas.this.sendInputEventToInputManager(keyEvent, 402);
                }

                public void keyTyped(KeyEvent keyEvent) {
                    PCanvas.this.sendInputEventToInputManager(keyEvent, 400);
                }
            };
            this.addKeyListener(this.keyListener);
        }
    }

    protected void removeInputSources() {
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener != null) {
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener != null) {
            this.removeMouseWheelListener(this.mouseWheelListener);
        }
        if (this.keyListener != null) {
            this.removeKeyListener(this.keyListener);
        }
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.mouseWheelListener = null;
        this.keyListener = null;
    }

    protected void sendInputEventToInputManager(InputEvent inputEvent, int n) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(inputEvent, n, this.getCamera());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    public void repaint(PBounds pBounds) {
        PDebug.processRepaint();
        pBounds.expandNearestIntegerDimensions();
        pBounds.inset(-1.0, -1.0);
        this.repaint((int)pBounds.x, (int)pBounds.y, (int)pBounds.width, (int)pBounds.height);
    }

    public void paintComponent(Graphics graphics) {
        PDebug.startProcessingOutput();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        PPaintContext pPaintContext = new PPaintContext(graphics2D);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality < this.animatingRenderQuality) {
                pPaintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                pPaintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            pPaintContext.setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint(pPaintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(graphics2D);
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        RepaintManager.currentManager(this).paintDirtyRegions();
        this.paintingImmediately = false;
    }

    public Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }
}

