/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.ZipCache;

public final class delete_file
extends Primitive {
    private static final Primitive DELETE_FILE = new delete_file();

    private delete_file() {
        super("delete-file", "filespec");
    }

    @Override
    public LispObject execute(LispObject arg) {
        File file;
        Pathname pathname = Lisp.coerceToPathname(arg);
        if (arg instanceof Stream) {
            ((Stream)arg)._close();
        }
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        if (pathname.isWild()) {
            return Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
        }
        Pathname defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL);
        if (defaultedPathname.isRemote()) {
            return Lisp.error(new FileError("Unable to delete remote pathnames", defaultedPathname));
        }
        if (defaultedPathname instanceof JarPathname) {
            JarPathname jar = (JarPathname)defaultedPathname;
            Pathname root = (Pathname)jar.getRootJar();
            Cons jars = (Cons)jar.getJars();
            if (jar.isArchiveEntry() || jars.length() > 1) {
                return Lisp.error(new FileError("Unable to delete entries within JAR-PATHNAME", jar));
            }
            ZipCache.remove(jar);
            file = root.getFile();
        } else {
            file = defaultedPathname.getFile();
        }
        if (file.exists()) {
            for (int i = 0; i < 2; ++i) {
                if (file.delete()) {
                    return Lisp.T;
                }
                ZipCache.remove(defaultedPathname);
                System.gc();
                Thread.yield();
            }
            Pathname truename = Pathname.create(file.getAbsolutePath());
            StringBuilder sb = new StringBuilder("Unable to delete ");
            sb.append(file.isDirectory() ? "directory " : "file ");
            sb.append(truename.princToString());
            sb.append('.');
            return Lisp.error(new FileError(sb.toString(), truename));
        }
        return Lisp.T;
    }
}

