/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketChannel
extends AbstractSelectableChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel,
NetworkChannel {
    protected SocketChannel(SelectorProvider selectorProvider) {
        super(selectorProvider);
    }

    public static SocketChannel open() throws IOException {
        return SelectorProvider.provider().openSocketChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SocketChannel open(SocketAddress socketAddress) throws IOException {
        SocketChannel socketChannel;
        block5: {
            socketChannel = SocketChannel.open();
            try {
                socketChannel.connect(socketAddress);
                Object var3_2 = null;
                if (socketChannel.isConnected()) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (socketChannel.isConnected()) throw throwable;
                try {
                    socketChannel.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            socketChannel.close();
        }
        if ($assertionsDisabled) return socketChannel;
        if (socketChannel.isConnected()) return socketChannel;
        throw new AssertionError();
    }

    @Override
    public final int validOps() {
        return 13;
    }

    @Override
    public abstract SocketChannel bind(SocketAddress var1) throws IOException;

    @Override
    public abstract <T> SocketChannel setOption(SocketOption<T> var1, T var2) throws IOException;

    public abstract SocketChannel shutdownInput() throws IOException;

    public abstract SocketChannel shutdownOutput() throws IOException;

    public abstract Socket socket();

    public abstract boolean isConnected();

    public abstract boolean isConnectionPending();

    public abstract boolean connect(SocketAddress var1) throws IOException;

    public abstract boolean finishConnect() throws IOException;

    public abstract SocketAddress getConnectedAddress() throws IOException;

    @Override
    public abstract int read(ByteBuffer var1) throws IOException;

    @Override
    public abstract long read(ByteBuffer[] var1, int var2, int var3) throws IOException;

    @Override
    public final long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    @Override
    public abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;

    @Override
    public final long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }
}

