/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.ListIterator;
import javax.management.ObjectName;
import sun.management.GcInfoBuilder;
import sun.management.MemoryManagerImpl;
import sun.management.Util;

class GarbageCollectorImpl
extends MemoryManagerImpl
implements GarbageCollectorMXBean {
    private String[] poolNames = null;
    private GcInfoBuilder gcInfoBuilder;

    GarbageCollectorImpl(String string) {
        super(string);
    }

    public native long getCollectionCount();

    public native long getCollectionTime();

    synchronized String[] getAllPoolNames() {
        if (this.poolNames == null) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            this.poolNames = new String[list.size()];
            int n = 0;
            ListIterator<MemoryPoolMXBean> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                MemoryPoolMXBean memoryPoolMXBean = listIterator.next();
                this.poolNames[n] = memoryPoolMXBean.getName();
                ++n;
            }
        }
        return this.poolNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GcInfo getLastGcInfo() {
        Object object = this;
        synchronized (object) {
            if (this.gcInfoBuilder == null) {
                this.gcInfoBuilder = new GcInfoBuilder(this, this.getAllPoolNames());
            }
        }
        object = this.gcInfoBuilder.getLastGcInfo();
        return object;
    }

    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
    }
}

