/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.java2d.DefaultDisposerRecord;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class Disposer
implements Runnable {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Hashtable records = new Hashtable();
    private static Disposer disposerInstance;
    public static final int WEAK = 0;
    public static final int PHANTOM = 1;
    public static int refType;

    public static void addRecord(Object object, long l, long l2) {
        disposerInstance.add(object, new DefaultDisposerRecord(l, l2));
    }

    public static void addRecord(Object object, DisposerRecord disposerRecord) {
        disposerInstance.add(object, disposerRecord);
    }

    synchronized void add(Object object, DisposerRecord disposerRecord) {
        if (object instanceof DisposerTarget) {
            object = ((DisposerTarget)object).getDisposerReferent();
        }
        Reference reference = refType == 1 ? new PhantomReference<Object>(object, queue) : new WeakReference<Object>(object, queue);
        records.put(reference, disposerRecord);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference reference = queue.remove();
                    reference.clear();
                    DisposerRecord disposerRecord = (DisposerRecord)records.remove(reference);
                    disposerRecord.dispose();
                    reference = null;
                    disposerRecord = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while removing reference: " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static native void initIDs();

    public static void addReference(Reference reference, DisposerRecord disposerRecord) {
        records.put(reference, disposerRecord);
    }

    public static void addObjectRecord(Object object, DisposerRecord disposerRecord) {
        records.put(new WeakReference<Object>(object, queue), disposerRecord);
    }

    public static ReferenceQueue getQueue() {
        return queue;
    }

    static {
        refType = 1;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Disposer.initIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.reftype"));
        if (string != null) {
            if (string.equals("weak")) {
                refType = 0;
                System.err.println("Using WEAK refs");
            } else {
                refType = 1;
                System.err.println("Using PHANTOM refs");
            }
        }
        disposerInstance = new Disposer();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Object object = threadGroup;
                while (object != null) {
                    threadGroup = object;
                    object = threadGroup.getParent();
                }
                object = new Thread(threadGroup, disposerInstance, "Java2D Disposer");
                ((Thread)object).setDaemon(true);
                ((Thread)object).setPriority(10);
                ((Thread)object).start();
                return null;
            }
        });
    }
}

