/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        BasicMenuItemUI.loadActionMap(lazyActionMap);
        lazyActionMap.put(new Actions("selectMenu", null, true));
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateDefaultBackgroundColor();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])DefaultLookup.get(this.menuItem, this, "Menu.shortcutKeys");
        if (nArray == null) {
            nArray = new int[]{8};
        }
        if (n == this.lastMnemonic) {
            return;
        }
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (this.lastMnemonic != 0 && inputMap != null) {
            for (int n2 : nArray) {
                inputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
            }
        }
        if (n != 0) {
            if (inputMap == null) {
                inputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
            }
            for (int n2 : nArray) {
                inputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.lastMnemonic = 0;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return null;
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this.getHandler();
    }

    BasicMenuItemUI.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.menuListener = null;
        this.handler = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return (MenuKeyListener)((Object)this.getHandler());
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new Actions("selectMenu", jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    private void updateDefaultBackgroundColor() {
        if (!UIManager.getBoolean("Menu.useMenuBarBackgroundForTopLevel")) {
            return;
        }
        JMenu jMenu = (JMenu)this.menuItem;
        if (jMenu.getBackground() instanceof UIResource) {
            if (jMenu.isTopLevelMenu()) {
                jMenu.setBackground(UIManager.getColor("MenuBar.background"));
            } else {
                jMenu.setBackground(UIManager.getColor(this.getPropertyPrefix() + ".background"));
            }
        }
    }

    private class Handler
    extends BasicMenuItemUI.Handler
    implements MenuKeyListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "mnemonic") {
                BasicMenuUI.this.updateMnemonicBinding();
            } else {
                if (propertyChangeEvent.getPropertyName().equals("ancestor")) {
                    BasicMenuUI.this.updateDefaultBackgroundColor();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected() && jMenu.getPopupMenu().isShowing()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    BasicMenuUI.appendPath(object, jMenu.getPopupMenu());
                } else {
                    BasicMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable")) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        BasicMenuUI.appendPath(BasicMenuUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[3];
                menuElementArray2[0] = (MenuElement)((Object)jMenu.getParent());
                menuElementArray2[1] = jMenu;
                if (BasicPopupMenuUI.getLastPopup() != null) {
                    menuElementArray2[2] = jMenu.getPopupMenu();
                }
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!BasicMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        BasicMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (!crossMenuMnemonic && BasicPopupMenuUI.getLastPopup() != null) {
                return;
            }
            char c = Character.toLowerCase((char)BasicMenuUI.this.menuItem.getMnemonic());
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            if (c == Character.toLowerCase(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu = ((JMenu)BasicMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuElementArray));
                arrayList.add(jPopupMenu);
                MenuElement[] menuElementArray2 = jPopupMenu.getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray2, -1, true);
                if (menuElement != null) {
                    arrayList.add(menuElement);
                }
                MenuElement[] menuElementArray3 = new MenuElement[]{};
                menuElementArray3 = arrayList.toArray(menuElementArray3);
                menuSelectionManager.setSelectedPath(menuElementArray3);
                menuKeyEvent.consume();
            } else if (((JMenu)BasicMenuUI.this.menuItem).isTopLevelMenu() && BasicPopupMenuUI.getLastPopup() == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public BasicMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.menu = jMenu;
            this.ui = basicMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseReleased(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicMenuUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT = "selectMenu";
        private JMenu menu;
        private boolean force = false;

        Actions(String string, JMenu jMenu, boolean bl) {
            super(string);
            this.menu = jMenu;
            this.force = bl;
        }

        private JMenu getMenu(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenu) {
                return (JMenu)actionEvent.getSource();
            }
            return this.menu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JMenu jMenu = this.getMenu(actionEvent);
            if (!crossMenuMnemonic && (object = BasicPopupMenuUI.getLastPopup()) != null && object != jMenu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = jMenu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = jMenu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), jMenu, jMenu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), jMenu, jMenu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == jMenu) {
                    BasicMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled(Object object) {
            if (object instanceof JMenu) {
                return ((JMenu)object).isEnabled();
            }
            return true;
        }
    }
}

