/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalEventTimer;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalMonitoredVm;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalVmManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoredHostProvider
extends MonitoredHost {
    private static final int DEFAULT_POLLING_INTERVAL = 1000;
    private ArrayList<HostListener> listeners;
    private NotifierTask task;
    private HashSet<Integer> activeVms;
    private LocalVmManager vmManager;

    public MonitoredHostProvider(HostIdentifier hostIdentifier) {
        this.hostId = hostIdentifier;
        this.listeners = new ArrayList();
        this.interval = 1000;
        this.activeVms = new HashSet();
        this.vmManager = new LocalVmManager();
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmIdentifier) throws MonitorException {
        return this.getMonitoredVm(vmIdentifier, 1000);
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmIdentifier, int n) throws MonitorException {
        try {
            VmIdentifier vmIdentifier2 = this.hostId.resolve(vmIdentifier);
            return new LocalMonitoredVm(vmIdentifier2, n);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Malformed URI: " + vmIdentifier.toString(), uRISyntaxException);
        }
    }

    @Override
    public void detach(MonitoredVm monitoredVm) {
        monitoredVm.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostListener(HostListener hostListener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(hostListener);
            if (this.task == null) {
                this.task = new NotifierTask();
                LocalEventTimer localEventTimer = LocalEventTimer.getInstance();
                localEventTimer.schedule((TimerTask)this.task, this.interval, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHostListener(HostListener hostListener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(hostListener);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int n) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (n == this.interval) {
                return;
            }
            int n2 = this.interval;
            super.setInterval(n);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask notifierTask = this.task;
                this.task = new NotifierTask();
                LocalEventTimer localEventTimer = LocalEventTimer.getInstance();
                CountedTimerTaskUtils.reschedule(localEventTimer, notifierTask, this.task, n2, n);
            }
        }
    }

    @Override
    public Set<Integer> activeVms() {
        return this.vmManager.activeVms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVmStatusChangedEvents(Set set, Set set2, Set set3) {
        ArrayList arrayList = null;
        VmStatusChangeEvent vmStatusChangeEvent = null;
        ArrayList<HostListener> arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (HostListener hostListener : arrayList) {
            if (vmStatusChangeEvent == null) {
                vmStatusChangeEvent = new VmStatusChangeEvent(this, set, set2, set3);
            }
            hostListener.vmStatusChanged(vmStatusChangeEvent);
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        public void run() {
            super.run();
            HashSet hashSet = MonitoredHostProvider.this.activeVms;
            MonitoredHostProvider.this.activeVms = (HashSet)MonitoredHostProvider.this.vmManager.activeVms();
            if (MonitoredHostProvider.this.activeVms.isEmpty()) {
                return;
            }
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            for (Integer n : MonitoredHostProvider.this.activeVms) {
                if (hashSet.contains(n)) continue;
                hashSet2.add(n);
            }
            for (Integer n : hashSet) {
                if (MonitoredHostProvider.this.activeVms.contains(n)) continue;
                hashSet3.add(n);
            }
            if (!hashSet2.isEmpty() || !hashSet3.isEmpty()) {
                MonitoredHostProvider.this.fireVmStatusChangedEvents(MonitoredHostProvider.this.activeVms, hashSet2, hashSet3);
            }
        }
    }
}

