/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.dtdparser;

import com.sun.xml.internal.dtdparser.XmlChars;

public class XmlNames {
    private XmlNames() {
    }

    public static boolean isName(String string) {
        if (string == null) {
            return false;
        }
        char c = string.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XmlChars.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnqualifiedName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XmlChars.isNCNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return XmlNames.isUnqualifiedName(string);
        }
        int n2 = string.lastIndexOf(58);
        if (n2 != n) {
            return false;
        }
        return XmlNames.isUnqualifiedName(string.substring(0, n)) && XmlNames.isUnqualifiedName(string.substring(n + 1));
    }

    public static boolean isNmtoken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (XmlChars.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNmtoken(String string) {
        return XmlNames.isNmtoken(string) && string.indexOf(58) < 0;
    }
}

