/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;

public class ConstantWriter
extends BasicWriter {
    StringValueVisitor stringValueVisitor = new StringValueVisitor();
    private ClassWriter classWriter;
    private Options options;

    static ConstantWriter instance(Context context) {
        ConstantWriter constantWriter = context.get(ConstantWriter.class);
        if (constantWriter == null) {
            constantWriter = new ConstantWriter(context);
        }
        return constantWriter;
    }

    protected ConstantWriter(Context context) {
        super(context);
        context.put(ConstantWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
        this.options = Options.instance(context);
    }

    void writeConstantPool() {
        ConstantPool.Visitor<Integer, Void> visitor = new ConstantPool.Visitor<Integer, Void>(){

            @Override
            public Integer visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, Void void_) {
                ConstantWriter.this.println("#" + cONSTANT_Class_info.name_index + ";\t//  " + ConstantWriter.this.stringValue(cONSTANT_Class_info));
                return 1;
            }

            @Override
            public Integer visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, Void void_) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(cONSTANT_Double_info) + ";");
                return 2;
            }

            @Override
            public Integer visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, Void void_) {
                ConstantWriter.this.println("#" + cONSTANT_Fieldref_info.class_index + ".#" + cONSTANT_Fieldref_info.name_and_type_index + ";\t//  " + ConstantWriter.this.stringValue(cONSTANT_Fieldref_info));
                return 1;
            }

            @Override
            public Integer visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, Void void_) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(cONSTANT_Float_info) + ";");
                return 1;
            }

            @Override
            public Integer visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, Void void_) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(cONSTANT_Integer_info) + ";");
                return 1;
            }

            @Override
            public Integer visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, Void void_) {
                ConstantWriter.this.println("#" + cONSTANT_InterfaceMethodref_info.class_index + ".#" + cONSTANT_InterfaceMethodref_info.name_and_type_index + ";\t//  " + ConstantWriter.this.stringValue(cONSTANT_InterfaceMethodref_info));
                return 1;
            }

            @Override
            public Integer visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, Void void_) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(cONSTANT_Long_info) + ";");
                return 2;
            }

            @Override
            public Integer visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, Void void_) {
                String string = ((ConstantWriter)ConstantWriter.this).options.compat ? "" : "\t";
                ConstantWriter.this.println("#" + cONSTANT_NameAndType_info.name_index + ":#" + cONSTANT_NameAndType_info.type_index + ";" + string + "//  " + ConstantWriter.this.stringValue(cONSTANT_NameAndType_info));
                return 1;
            }

            @Override
            public Integer visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, Void void_) {
                ConstantWriter.this.println("#" + cONSTANT_Methodref_info.class_index + ".#" + cONSTANT_Methodref_info.name_and_type_index + ";\t//  " + ConstantWriter.this.stringValue(cONSTANT_Methodref_info));
                return 1;
            }

            @Override
            public Integer visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, Void void_) {
                ConstantWriter.this.println("#" + cONSTANT_String_info.string_index + ";\t//  " + ConstantWriter.this.stringValue(cONSTANT_String_info));
                return 1;
            }

            @Override
            public Integer visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, Void void_) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(cONSTANT_Utf8_info) + ";");
                return 1;
            }
        };
        this.println("  Constant pool:");
        ConstantPool constantPool = this.classWriter.getClassFile().constant_pool;
        int n = 1;
        while (n < constantPool.size()) {
            try {
                ConstantPool.CPInfo cPInfo = constantPool.get(n);
                this.print("const #" + n + " = " + this.tagName(cPInfo.getTag()) + "\t");
                n += cPInfo.accept(visitor, null).intValue();
            }
            catch (ConstantPool.InvalidIndex invalidIndex) {
                this.print("const #" + n);
            }
        }
    }

    void write(int n) {
        ConstantPool.CPInfo cPInfo;
        ClassFile classFile = this.classWriter.getClassFile();
        if (n == 0) {
            this.print("#0");
            return;
        }
        try {
            cPInfo = classFile.constant_pool.get(n);
        }
        catch (ConstantPoolException constantPoolException) {
            this.print("#" + n);
            return;
        }
        int n2 = cPInfo.getTag();
        switch (n2) {
            case 9: 
            case 10: 
            case 11: {
                ConstantPool.CPRefInfo cPRefInfo = (ConstantPool.CPRefInfo)cPInfo;
                try {
                    if (cPRefInfo.class_index != classFile.this_class) break;
                    cPInfo = classFile.constant_pool.get(cPRefInfo.name_and_type_index);
                    break;
                }
                catch (ConstantPool.InvalidIndex invalidIndex) {
                    // empty catch block
                }
            }
        }
        this.print(this.tagName(n2) + " " + this.stringValue(cPInfo));
    }

    String tagName(int n) {
        switch (n) {
            case 1: {
                return "Asciz";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Field";
            }
            case 10: {
                return "Method";
            }
            case 11: {
                return "InterfaceMethod";
            }
            case 12: {
                return "NameAndType";
            }
        }
        return "unknown tag";
    }

    String stringValue(int n) {
        ClassFile classFile = this.classWriter.getClassFile();
        try {
            return this.stringValue(classFile.constant_pool.get(n));
        }
        catch (ConstantPool.InvalidIndex invalidIndex) {
            return this.report(invalidIndex);
        }
    }

    String stringValue(ConstantPool.CPInfo cPInfo) {
        return this.stringValueVisitor.visit(cPInfo);
    }

    private static String checkName(String string) {
        int n;
        if (string == null) {
            return "null";
        }
        int n2 = string.length();
        if (n2 == 0) {
            return "\"\"";
        }
        int n3 = 47;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n3 == 47 && !Character.isJavaIdentifierStart(n) || n != 47 && !Character.isJavaIdentifierPart(n)) {
                return "\"" + string + "\"";
            }
            n3 = n;
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringValueVisitor
    implements ConstantPool.Visitor<String, Void> {
        private StringValueVisitor() {
        }

        public String visit(ConstantPool.CPInfo cPInfo) {
            return cPInfo.accept(this, null);
        }

        @Override
        public String visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, Void void_) {
            return this.getCheckedName(cONSTANT_Class_info);
        }

        String getCheckedName(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info) {
            try {
                return ConstantWriter.checkName(cONSTANT_Class_info.getName());
            }
            catch (ConstantPoolException constantPoolException) {
                return ConstantWriter.this.report(constantPoolException);
            }
        }

        @Override
        public String visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, Void void_) {
            return cONSTANT_Double_info.value + "d";
        }

        @Override
        public String visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, Void void_) {
            return this.visitRef(cONSTANT_Fieldref_info, void_);
        }

        @Override
        public String visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, Void void_) {
            return cONSTANT_Float_info.value + "f";
        }

        @Override
        public String visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, Void void_) {
            return String.valueOf(cONSTANT_Integer_info.value);
        }

        @Override
        public String visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, Void void_) {
            return this.visitRef(cONSTANT_InterfaceMethodref_info, void_);
        }

        @Override
        public String visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, Void void_) {
            return cONSTANT_Long_info.value + "l";
        }

        @Override
        public String visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, Void void_) {
            return this.getCheckedName(cONSTANT_NameAndType_info) + ":" + this.getType(cONSTANT_NameAndType_info);
        }

        String getCheckedName(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info) {
            try {
                return ConstantWriter.checkName(cONSTANT_NameAndType_info.getName());
            }
            catch (ConstantPoolException constantPoolException) {
                return ConstantWriter.this.report(constantPoolException);
            }
        }

        String getType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info) {
            try {
                return cONSTANT_NameAndType_info.getType();
            }
            catch (ConstantPoolException constantPoolException) {
                return ConstantWriter.this.report(constantPoolException);
            }
        }

        @Override
        public String visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, Void void_) {
            return this.visitRef(cONSTANT_Methodref_info, void_);
        }

        @Override
        public String visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, Void void_) {
            try {
                ClassFile classFile = ConstantWriter.this.classWriter.getClassFile();
                int n = cONSTANT_String_info.string_index;
                return ConstantWriter.this.stringValue(classFile.constant_pool.getUTF8Info(n));
            }
            catch (ConstantPoolException constantPoolException) {
                return ConstantWriter.this.report(constantPoolException);
            }
        }

        @Override
        public String visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, Void void_) {
            String string = cONSTANT_Utf8_info.value;
            StringBuilder stringBuilder = new StringBuilder();
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\t': {
                        stringBuilder.append('\\').append('t');
                        continue block6;
                    }
                    case '\n': {
                        stringBuilder.append('\\').append('n');
                        continue block6;
                    }
                    case '\r': {
                        stringBuilder.append('\\').append('r');
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append('\\').append('\"');
                        continue block6;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }

        String visitRef(ConstantPool.CPRefInfo cPRefInfo, Void void_) {
            String string;
            String string2 = this.getCheckedClassName(cPRefInfo);
            try {
                string = ConstantWriter.this.stringValue(cPRefInfo.getNameAndTypeInfo());
            }
            catch (ConstantPoolException constantPoolException) {
                string = ConstantWriter.this.report(constantPoolException);
            }
            return string2 + "." + string;
        }

        String getCheckedClassName(ConstantPool.CPRefInfo cPRefInfo) {
            try {
                return ConstantWriter.checkName(cPRefInfo.getClassName());
            }
            catch (ConstantPoolException constantPoolException) {
                return ConstantWriter.this.report(constantPoolException);
            }
        }
    }
}

