/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.tools.JavaFileObject;

public class BasicDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    protected Map<BasicFormatKind, String> availableFormats;

    BasicDiagnosticFormatter(Options options, JavacMessages javacMessages) {
        super(javacMessages, options, true);
        this.initAvailableFormats();
        String string = options.get("diags");
        if (string != null) {
            String[] stringArray = string.split("\\|");
            switch (stringArray.length) {
                case 3: {
                    this.availableFormats.put(BasicFormatKind.DEFAULT_CLASS_FORMAT, stringArray[2]);
                }
                case 2: {
                    this.availableFormats.put(BasicFormatKind.DEFAULT_NO_POS_FORMAT, stringArray[1]);
                }
            }
            this.availableFormats.put(BasicFormatKind.DEFAULT_POS_FORMAT, stringArray[0]);
        }
    }

    public BasicDiagnosticFormatter(JavacMessages javacMessages) {
        super(javacMessages, true);
        this.initAvailableFormats();
    }

    public void initAvailableFormats() {
        this.availableFormats = new HashMap<BasicFormatKind, String>();
        this.availableFormats.put(BasicFormatKind.DEFAULT_POS_FORMAT, "%f:%l:%_%t%m");
        this.availableFormats.put(BasicFormatKind.DEFAULT_NO_POS_FORMAT, "%p%m");
        this.availableFormats.put(BasicFormatKind.DEFAULT_CLASS_FORMAT, "%f:%_%t%m");
    }

    public String format(JCDiagnostic jCDiagnostic, Locale locale) {
        if (locale == null) {
            locale = this.messages.getCurrentLocale();
        }
        String string = this.selectFormat(jCDiagnostic);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            if (c == '%' && i < string.length() - 1) {
                bl = true;
                c = string.charAt(++i);
            }
            stringBuilder.append(bl ? this.formatMeta(c, jCDiagnostic, locale) : String.valueOf(c));
        }
        if (this.displaySource(jCDiagnostic)) {
            stringBuilder.append("\n" + this.formatSourceLine(jCDiagnostic));
        }
        return stringBuilder.toString();
    }

    protected String formatMeta(char c, JCDiagnostic jCDiagnostic, Locale locale) {
        switch (c) {
            case 'b': {
                return this.formatSource(jCDiagnostic, false, locale);
            }
            case 'e': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.END, locale);
            }
            case 'f': {
                return this.formatSource(jCDiagnostic, true, locale);
            }
            case 'l': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.LINE, locale);
            }
            case 'c': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.COLUMN, locale);
            }
            case 'o': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.OFFSET, locale);
            }
            case 'p': {
                return this.formatKind(jCDiagnostic, locale);
            }
            case 's': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.START, locale);
            }
            case 't': {
                boolean bl;
                switch (jCDiagnostic.getType()) {
                    case FRAGMENT: {
                        bl = false;
                        break;
                    }
                    case ERROR: {
                        bl = jCDiagnostic.getIntPosition() == -1;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    return this.formatKind(jCDiagnostic, locale);
                }
                return "";
            }
            case 'm': {
                return this.formatMessage(jCDiagnostic, locale);
            }
            case '_': {
                return " ";
            }
            case '%': {
                return "%";
            }
        }
        return String.valueOf(c);
    }

    private String selectFormat(JCDiagnostic jCDiagnostic) {
        DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        String string = this.availableFormats.get((Object)BasicFormatKind.DEFAULT_NO_POS_FORMAT);
        if (diagnosticSource != null) {
            if (jCDiagnostic.getIntPosition() != -1) {
                string = this.availableFormats.get((Object)BasicFormatKind.DEFAULT_POS_FORMAT);
            } else if (diagnosticSource.getFile() != null && diagnosticSource.getFile().getKind() == JavaFileObject.Kind.CLASS) {
                string = this.availableFormats.get((Object)BasicFormatKind.DEFAULT_CLASS_FORMAT);
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BasicFormatKind {
        DEFAULT_POS_FORMAT,
        DEFAULT_NO_POS_FORMAT,
        DEFAULT_CLASS_FORMAT;

    }
}

