/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.util;

public class Misc {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String toHex(int n) {
        char[] cArray = new char[8];
        int n2 = 0;
        for (int i = 28; i >= 0; i -= 4) {
            cArray[n2++] = digits[n >> i & 0xF];
        }
        return "0x" + new String(cArray);
    }

    public static final String toHex(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static final long parseHex(String string) {
        long l = 0L;
        if (string.length() < 2 || string.charAt(0) != '0' || string.charAt(1) != 'x') {
            return -1L;
        }
        for (int i = 2; i < string.length(); ++i) {
            l *= 16L;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                l += (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                l += (long)(c - 97 + 10);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                l += (long)(c - 65 + 10);
                continue;
            }
            throw new NumberFormatException("" + c + " is not a valid hex digit");
        }
        return l;
    }

    public static String encodeHtml(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&#039;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c < ' ') {
                stringBuffer.append("&#" + Integer.toString(c) + ";");
                continue;
            }
            int n2 = c & 0xFFFF;
            if (n2 > 127) {
                stringBuffer.append("&#" + Integer.toString(n2) + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

