/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaLazyReadObject;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import java.io.IOException;

public class JavaObjectArray
extends JavaLazyReadObject {
    private Object clazz;

    public JavaObjectArray(long l, long l2) {
        super(l2);
        this.clazz = JavaObjectArray.makeId(l);
    }

    public JavaClass getClazz() {
        return (JavaClass)this.clazz;
    }

    public void resolve(Snapshot snapshot) {
        JavaHeapObject javaHeapObject;
        if (this.clazz instanceof JavaClass) {
            return;
        }
        long l = JavaObjectArray.getIdValue((Number)this.clazz);
        if (snapshot.isNewStyleArrayClass() && (javaHeapObject = snapshot.findThing(l)) instanceof JavaClass) {
            this.clazz = (JavaClass)javaHeapObject;
        }
        if (!(this.clazz instanceof JavaClass) && (javaHeapObject = snapshot.findThing(l)) != null && javaHeapObject instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)javaHeapObject;
            String string = javaClass.getName();
            if (!string.startsWith("[")) {
                string = "L" + javaClass.getName() + ";";
            }
            this.clazz = snapshot.getArrayClass(string);
        }
        if (!(this.clazz instanceof JavaClass)) {
            this.clazz = snapshot.getOtherArrayType();
        }
        ((JavaClass)this.clazz).addInstance(this);
        super.resolve(snapshot);
    }

    public JavaThing[] getValues() {
        return this.getElements();
    }

    public JavaThing[] getElements() {
        Snapshot snapshot = this.getClazz().getSnapshot();
        byte[] byArray = this.getValue();
        int n = snapshot.getIdentifierSize();
        int n2 = byArray.length / n;
        JavaThing[] javaThingArray = new JavaThing[n2];
        int n3 = 0;
        for (int i = 0; i < javaThingArray.length; ++i) {
            long l = this.objectIdAt(n3, byArray);
            n3 += n;
            javaThingArray[i] = snapshot.findThing(l);
        }
        return javaThingArray;
    }

    public int compareTo(JavaThing javaThing) {
        if (javaThing instanceof JavaObjectArray) {
            return 0;
        }
        return super.compareTo(javaThing);
    }

    public int getLength() {
        return this.getValueLength() / this.getClazz().getIdentifierSize();
    }

    public void visitReferencedObjects(JavaHeapObjectVisitor javaHeapObjectVisitor) {
        super.visitReferencedObjects(javaHeapObjectVisitor);
        JavaThing[] javaThingArray = this.getElements();
        for (int i = 0; i < javaThingArray.length; ++i) {
            if (javaThingArray[i] == null || !(javaThingArray[i] instanceof JavaHeapObject)) continue;
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThingArray[i]);
        }
    }

    public String describeReferenceTo(JavaThing javaThing, Snapshot snapshot) {
        JavaThing[] javaThingArray = this.getElements();
        for (int i = 0; i < javaThingArray.length; ++i) {
            if (javaThingArray[i] != javaThing) continue;
            return "Element " + i + " of " + this;
        }
        return super.describeReferenceTo(javaThing, snapshot);
    }

    protected final int readValueLength() throws IOException {
        JavaClass javaClass = this.getClazz();
        ReadBuffer readBuffer = javaClass.getReadBuffer();
        int n = javaClass.getIdentifierSize();
        long l = this.getOffset() + (long)n + 4L;
        int n2 = readBuffer.getInt(l);
        return n2 * javaClass.getIdentifierSize();
    }

    protected final byte[] readValue() throws IOException {
        JavaClass javaClass = this.getClazz();
        ReadBuffer readBuffer = javaClass.getReadBuffer();
        int n = javaClass.getIdentifierSize();
        long l = this.getOffset() + (long)n + 4L;
        int n2 = readBuffer.getInt(l);
        if (n2 == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2 * n];
        readBuffer.get(l + 4L + (long)n, byArray);
        return byArray;
    }
}

