/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmMemGCEntryImpl;
import sun.management.snmp.jvminstr.JvmMemManagerTableMetaImpl;
import sun.management.snmp.jvmmib.JvmMemGCTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemGCTableMetaImpl
extends JvmMemGCTableMeta {
    private transient JvmMemManagerTableMetaImpl managers = null;
    private static GCTableFilter filter = new GCTableFilter();
    static final MibLogger log = new MibLogger(JvmMemGCTableMetaImpl.class);

    public JvmMemGCTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
    }

    private final JvmMemManagerTableMetaImpl getManagers(SnmpMib snmpMib) {
        if (this.managers == null) {
            this.managers = (JvmMemManagerTableMetaImpl)snmpMib.getRegisteredTableMeta("JvmMemManagerTable");
        }
        return this.managers;
    }

    protected SnmpTableHandler getHandler(Object object) {
        JvmMemManagerTableMetaImpl jvmMemManagerTableMetaImpl = this.getManagers(this.theMib);
        return jvmMemManagerTableMetaImpl.getHandler(object);
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        boolean bl = log.isDebugOn();
        try {
            SnmpTableHandler snmpTableHandler;
            if (bl) {
                log.debug("getNextOid", "previous=" + snmpOid);
            }
            if ((snmpTableHandler = this.getHandler(object)) == null) {
                if (bl) {
                    log.debug("getNextOid", "handler is null!");
                }
                throw new SnmpStatusException(224);
            }
            SnmpOid snmpOid2 = filter.getNext(snmpTableHandler, snmpOid);
            if (bl) {
                log.debug("getNextOid", "next=" + snmpOid2);
            }
            if (snmpOid2 == null) {
                throw new SnmpStatusException(224);
            }
            return snmpOid2;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                log.debug("getNextOid", runtimeException);
            }
            throw runtimeException;
        }
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return filter.contains(snmpTableHandler, snmpOid);
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        if (snmpOid == null) {
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> map = JvmContextFactory.getUserData();
        long l = snmpOid.getOidArc(0);
        String string2 = string = map == null ? null : "JvmMemGCTable.entry." + l;
        if (map != null && (object = map.get(string)) != null) {
            return object;
        }
        object = this.getHandler(map);
        if (object == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = filter.getData((SnmpTableHandler)object, snmpOid);
        if (object2 == null) {
            throw new SnmpStatusException(224);
        }
        JvmMemGCEntryImpl jvmMemGCEntryImpl = new JvmMemGCEntryImpl((GarbageCollectorMXBean)object2, (int)l);
        if (map != null && jvmMemGCEntryImpl != null) {
            map.put(string, jvmMemGCEntryImpl);
        }
        return jvmMemGCEntryImpl;
    }

    protected static class GCTableFilter {
        protected GCTableFilter() {
        }

        public SnmpOid getNext(SnmpCachedData snmpCachedData, SnmpOid snmpOid) {
            int n;
            boolean bl = log.isDebugOn();
            int n2 = n = snmpOid == null ? -1 : snmpCachedData.find(snmpOid);
            if (bl) {
                log.debug("GCTableFilter", "oid=" + snmpOid + " at insertion=" + n);
            }
            for (int i = n > -1 ? n + 1 : -n - 1; i < snmpCachedData.indexes.length; ++i) {
                if (bl) {
                    log.debug("GCTableFilter", "next=" + i);
                }
                Object object = snmpCachedData.datas[i];
                if (bl) {
                    log.debug("GCTableFilter", "value[" + i + "]=" + ((MemoryManagerMXBean)object).getName());
                }
                if (object instanceof GarbageCollectorMXBean) {
                    if (bl) {
                        log.debug("GCTableFilter", ((MemoryManagerMXBean)object).getName() + " is a  GarbageCollectorMXBean.");
                    }
                    return snmpCachedData.indexes[i];
                }
                if (!bl) continue;
                log.debug("GCTableFilter", ((MemoryManagerMXBean)object).getName() + " is not a  GarbageCollectorMXBean: " + object.getClass().getName());
            }
            return null;
        }

        public SnmpOid getNext(SnmpTableHandler snmpTableHandler, SnmpOid snmpOid) {
            if (snmpTableHandler instanceof SnmpCachedData) {
                return this.getNext((SnmpCachedData)snmpTableHandler, snmpOid);
            }
            SnmpOid snmpOid2 = snmpOid;
            do {
                Object object;
                if (!((object = snmpTableHandler.getData(snmpOid2 = snmpTableHandler.getNext(snmpOid2))) instanceof GarbageCollectorMXBean)) continue;
                return snmpOid2;
            } while (snmpOid2 != null);
            return null;
        }

        public Object getData(SnmpTableHandler snmpTableHandler, SnmpOid snmpOid) {
            Object object = snmpTableHandler.getData(snmpOid);
            if (object instanceof GarbageCollectorMXBean) {
                return object;
            }
            return null;
        }

        public boolean contains(SnmpTableHandler snmpTableHandler, SnmpOid snmpOid) {
            return snmpTableHandler.getData(snmpOid) instanceof GarbageCollectorMXBean;
        }
    }
}

