/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.xml.internal.ws.transport.WSConnectionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectionImpl
extends WSConnectionImpl {
    private HttpExchange httpExchange;
    private int status;
    private Map<String, List<String>> requestHeaders;
    private Map<String, List<String>> responseHeaders;
    private NoCloseInputStream is;
    private NoCloseOutputStream out;
    private boolean closedInput;
    private boolean closedOutput;

    public ServerConnectionImpl(HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    @Override
    public void setHeaders(Map<String, List<String>> map) {
        this.responseHeaders = map;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    public int getStatus() {
        if (this.status == 0) {
            this.status = 500;
        }
        return this.status;
    }

    @Override
    public InputStream getInput() {
        if (this.is == null) {
            this.is = new NoCloseInputStream(this.httpExchange.getRequestBody());
        }
        return this.is;
    }

    @Override
    public OutputStream getOutput() {
        if (this.out == null) {
            try {
                this.closeInput();
                int n = 0;
                if (this.responseHeaders != null) {
                    for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                        String string = entry.getKey();
                        List<String> list = entry.getValue();
                        if (string.equals("Content-Length")) {
                            n = Integer.valueOf(list.get(0));
                            continue;
                        }
                        for (String string2 : list) {
                            this.httpExchange.getResponseHeaders().add(string, string2);
                        }
                    }
                }
                this.httpExchange.sendResponseHeaders(this.getStatus(), n);
                this.out = new NoCloseOutputStream(this.httpExchange.getResponseBody());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.out;
    }

    @Override
    public void closeOutput() {
        if (this.out != null) {
            try {
                this.out.getOutputStream().close();
                this.closedOutput = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.out = null;
    }

    @Override
    public void closeInput() {
        if (this.is != null) {
            try {
                byte[] byArray = new byte[1024];
                while (this.is.read(byArray) != -1) {
                }
                this.is.getInputStream().close();
                this.closedInput = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.is = null;
    }

    @Override
    public void close() {
        this.httpExchange.close();
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        private OutputStream out;

        public NoCloseOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void close() throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public OutputStream getOutputStream() {
            return this.out;
        }
    }

    private static class NoCloseInputStream
    extends InputStream {
        private InputStream is;

        public NoCloseInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.is.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            return this.is.skip(l);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void mark(int n) {
            this.is.mark(n);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }
    }
}

