/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerThreadGroupPool<T extends ThreadPoolExecutor> {
    private final WeakIdentityHashMap<ThreadGroup, WeakReference<T>> map = WeakIdentityHashMap.make();

    private PerThreadGroupPool() {
    }

    public static <T extends ThreadPoolExecutor> PerThreadGroupPool<T> make() {
        return new PerThreadGroupPool<T>();
    }

    public synchronized T getThreadPoolExecutor(Create<T> create) {
        ThreadPoolExecutor threadPoolExecutor;
        SecurityManager securityManager = System.getSecurityManager();
        ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        WeakReference<T> weakReference = this.map.get(threadGroup);
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = weakReference == null ? null : (ThreadPoolExecutor)weakReference.get();
        if (threadPoolExecutor == null) {
            threadPoolExecutor = create.createThreadPool(threadGroup);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.map.put(threadGroup, new WeakReference<ThreadPoolExecutor>(threadPoolExecutor));
        }
        return (T)threadPoolExecutor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Create<T extends ThreadPoolExecutor> {
        public T createThreadPool(ThreadGroup var1);
    }
}

