/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.DispatchInterceptor;
import com.sun.jmx.interceptor.DomainDispatchInterceptor;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.namespace.NamespaceInterceptor;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.namespace.JMXDomain;
import javax.management.namespace.JMXNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDispatchInterceptor
extends DispatchInterceptor<NamespaceInterceptor, JMXNamespace> {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private static final int NAMESPACE_SEPARATOR_LENGTH = "//".length();
    private static final ObjectName X3 = ObjectName.valueOf("x:x=x");
    private final DomainDispatchInterceptor nextInterceptor;
    private final String serverName;

    public NamespaceDispatchInterceptor(MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, Repository repository) {
        this.nextInterceptor = new DomainDispatchInterceptor(mBeanServer, mBeanServerDelegate, mBeanInstantiator, repository, this);
        this.serverName = Util.getMBeanServerSecurityName(mBeanServerDelegate);
    }

    static String getFirstNamespaceWithSlash(ObjectName objectName) {
        if (objectName == null) {
            return "";
        }
        String string = objectName.getDomain();
        if (string.equals("")) {
            return "";
        }
        int n = string.indexOf("//");
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(0, n + NAMESPACE_SEPARATOR_LENGTH);
        return string2;
    }

    final void checkLocallyRegistrable(Object object, ObjectName objectName) {
        if (!(object instanceof JMXNamespace) && objectName.getDomain().contains("//")) {
            throw new IllegalArgumentException(String.valueOf(objectName) + ": Invalid ObjectName for an instance of " + object.getClass().getName());
        }
    }

    private final String getKeyFor(String string) {
        int n = string.length() - NAMESPACE_SEPARATOR_LENGTH;
        if (n <= 0) {
            return "";
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    @Override
    final MBeanServer getInterceptorOrNullFor(ObjectName objectName) {
        String string = NamespaceDispatchInterceptor.getFirstNamespaceWithSlash(objectName);
        if (string.equals("//")) {
            LOG.finer("ObjectName starts with: " + string);
            return null;
        }
        if (string.equals("") || objectName.getDomain().equals(string)) {
            LOG.finer("dispatching to local name space");
            return this.nextInterceptor;
        }
        String string2 = this.getKeyFor(string);
        NamespaceInterceptor namespaceInterceptor = (NamespaceInterceptor)this.getInterceptor(string2);
        if (LOG.isLoggable(Level.FINER)) {
            if (namespaceInterceptor != null) {
                LOG.finer("dispatching to name space: " + string2);
            } else {
                LOG.finer("no handler for: " + string2);
            }
        }
        return namespaceInterceptor;
    }

    @Override
    final DispatchInterceptor.QueryInterceptor getInterceptorForQuery(ObjectName objectName) {
        String string = NamespaceDispatchInterceptor.getFirstNamespaceWithSlash(objectName);
        if (string.equals("//")) {
            LOG.finer("ObjectName starts with: " + string);
            return null;
        }
        if (string.equals("") || objectName.getDomain().equals(string)) {
            LOG.finer("dispatching to local name space");
            return new DispatchInterceptor.QueryInterceptor(this.nextInterceptor);
        }
        if (X3.withDomain(string).isDomainPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Pattern not allowed in namespace path"));
        }
        String string2 = this.getKeyFor(string);
        NamespaceInterceptor namespaceInterceptor = (NamespaceInterceptor)this.getInterceptor(string2);
        if (LOG.isLoggable(Level.FINER)) {
            if (namespaceInterceptor != null) {
                LOG.finer("dispatching to name space: " + string2);
            } else {
                LOG.finer("no handler for: " + string2);
            }
        }
        if (namespaceInterceptor == null) {
            return null;
        }
        return new DispatchInterceptor.QueryInterceptor(namespaceInterceptor);
    }

    @Override
    final ObjectName getHandlerNameFor(String string) {
        return ObjectName.valueOf(string + "//", "type", "JMXNamespace");
    }

    @Override
    public final String getHandlerKey(ObjectName objectName) {
        String string = NamespaceDispatchInterceptor.getFirstNamespaceWithSlash(objectName);
        return this.getKeyFor(string);
    }

    @Override
    final NamespaceInterceptor createInterceptorFor(String string, ObjectName objectName, JMXNamespace jMXNamespace, Queue<Runnable> queue) {
        NamespaceInterceptor namespaceInterceptor = new NamespaceInterceptor(this.serverName, jMXNamespace, string);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("NamespaceInterceptor created: " + namespaceInterceptor);
        }
        return namespaceInterceptor;
    }

    @Override
    final DomainDispatchInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    @Override
    public String[] getDomains() {
        return this.nextInterceptor.getDomains();
    }

    @Override
    public void addInterceptorFor(ObjectName objectName, JMXNamespace jMXNamespace, Queue<Runnable> queue) {
        if (jMXNamespace instanceof JMXDomain) {
            this.nextInterceptor.addInterceptorFor(objectName, (JMXDomain)jMXNamespace, queue);
        } else {
            super.addInterceptorFor(objectName, jMXNamespace, queue);
        }
    }

    @Override
    public void removeInterceptorFor(ObjectName objectName, JMXNamespace jMXNamespace, Queue<Runnable> queue) {
        if (jMXNamespace instanceof JMXDomain) {
            this.nextInterceptor.removeInterceptorFor(objectName, (JMXDomain)jMXNamespace, queue);
        } else {
            super.removeInterceptorFor(objectName, jMXNamespace, queue);
        }
    }
}

