/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XOMCharSetList
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    public int getDataSize() {
        return XOMCharSetList.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    XOMCharSetList(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    XOMCharSetList() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XOMCharSetList.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_charset_count() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_charset_count(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public long get_charset_list(int n) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(n * Native.getLongSize());
    }

    public long get_charset_list() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_charset_list(long l) {
        log.finest("");
        Native.putLong(this.pData + 8L, l);
    }

    String getName() {
        return "XOMCharSetList";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "charset_count = " + this.get_charset_count() + ", ";
        string = string + "charset_list = " + this.get_charset_list() + ", ";
        return string;
    }
}

