/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.event.EventClientFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.event.EventClient;
import javax.management.event.EventClientDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventClientConnection
implements InvocationHandler,
EventClientFactory {
    private static final Logger LOG = JmxProperties.NOTIFICATION_LOGGER;
    private static final int NAMESPACE_SEPARATOR_LENGTH = "//".length();
    private static final short TRYLOCK_TIMEOUT = 3;
    private final MBeanServerConnection connection;
    private final Callable<EventClient> eventClientFactory;
    private final Lock lock;
    private volatile EventClient client = null;
    private volatile boolean initialized = false;

    public EventClientConnection(MBeanServerConnection mBeanServerConnection) {
        this(mBeanServerConnection, null);
    }

    public EventClientConnection(MBeanServerConnection mBeanServerConnection, Callable<EventClient> callable) {
        if (mBeanServerConnection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.connection = mBeanServerConnection;
        if (callable == null) {
            callable = new Callable<EventClient>(){

                @Override
                public final EventClient call() throws Exception {
                    return EventClientConnection.this.createEventClient(EventClientConnection.this.connection);
                }
            };
        }
        this.eventClientFactory = callable;
        this.lock = new ReentrantLock();
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    private static <T extends MBeanServerConnection> T newProxyInstance(T t, Class<T> clazz, Callable<EventClient> callable) {
        EventClientConnection eventClientConnection = new EventClientConnection(t, callable);
        Class[] classArray = new Class[]{clazz, EventClientFactory.class};
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, eventClientConnection);
        return (T)((MBeanServerConnection)clazz.cast(object));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        String string = method.getName();
        if ((string.equals("addNotificationListener") || string.equals("removeNotificationListener")) && ((Class<?>[])(object2 = method.getParameterTypes())).length > 1 && NotificationListener.class.isAssignableFrom((Class<?>)object2[1])) {
            return this.invokeBroadcasterMethod(object, method, objectArray);
        }
        object2 = method.getDeclaringClass();
        if (object2.equals(EventClientFactory.class)) {
            return this.invokeEventClientSubscriberMethod(object, method, objectArray);
        }
        if (this.shouldDoLocally(object, method)) {
            return this.doLocally(object, method, objectArray);
        }
        return this.call(this.connection, method, objectArray);
    }

    private Object call(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throw invocationTargetException;
            }
            throw throwable;
        }
    }

    private Object invokeBroadcasterMethod(Object object, Method method, Object[] objectArray) throws Exception {
        Object object2;
        int n;
        int n2;
        String string = method.getName();
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (n2 < 1) {
            String string2 = "Bad arg count: " + n2;
            throw new IllegalArgumentException(string2);
        }
        ObjectName objectName = (ObjectName)objectArray[0];
        EventClient eventClient = this.getEventClient();
        if (eventClient == null && (n = ((String)(object2 = objectName.getDomain())).indexOf("//")) > -1 && n < ((String)object2).length() - NAMESPACE_SEPARATOR_LENGTH) {
            throw new UnsupportedOperationException(method.getName() + " on namespace " + ((String)object2).substring(0, n + NAMESPACE_SEPARATOR_LENGTH));
        }
        if (string.equals("addNotificationListener")) {
            if (n2 != 4) {
                object2 = "Bad arg count to addNotificationListener: " + n2;
                throw new IllegalArgumentException((String)object2);
            }
            object2 = (NotificationListener)objectArray[1];
            NotificationFilter notificationFilter = (NotificationFilter)objectArray[2];
            Object object3 = objectArray[3];
            if (eventClient != null) {
                eventClient.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object3);
            } else {
                this.connection.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object3);
            }
            return null;
        }
        if (string.equals("removeNotificationListener")) {
            object2 = (NotificationListener)objectArray[1];
            switch (n2) {
                case 2: {
                    if (eventClient != null) {
                        eventClient.removeNotificationListener(objectName, (NotificationListener)object2);
                    } else {
                        this.connection.removeNotificationListener(objectName, (NotificationListener)object2);
                    }
                    return null;
                }
                case 4: {
                    NotificationFilter notificationFilter = (NotificationFilter)objectArray[2];
                    Object object4 = objectArray[3];
                    if (eventClient != null) {
                        eventClient.removeNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object4);
                    } else {
                        this.connection.removeNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object4);
                    }
                    return null;
                }
            }
            String string3 = "Bad arg count to removeNotificationListener: " + n2;
            throw new IllegalArgumentException(string3);
        }
        throw new IllegalArgumentException("Bad method name: " + string);
    }

    private boolean shouldDoLocally(Object object, Method method) {
        String string = method.getName();
        if ((string.equals("hashCode") || string.equals("toString")) && method.getParameterTypes().length == 0 && EventClientConnection.isLocal(object, method)) {
            return true;
        }
        return string.equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class}) && EventClientConnection.isLocal(object, method);
    }

    private Object doLocally(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("equals")) {
            if (this == objectArray[0]) {
                return true;
            }
            if (!(objectArray[0] instanceof Proxy)) {
                return false;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(objectArray[0]);
            if (invocationHandler == null || !(invocationHandler instanceof EventClientConnection)) {
                return false;
            }
            EventClientConnection eventClientConnection = (EventClientConnection)invocationHandler;
            return this.connection.equals(eventClientConnection.connection) && object.getClass().equals(objectArray[0].getClass());
        }
        if (string.equals("hashCode")) {
            return this.connection.hashCode();
        }
        throw new RuntimeException("Unexpected method name: " + string);
    }

    private static boolean isLocal(Object object, Method method) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        if (classArray == null) {
            return true;
        }
        String string = method.getName();
        Class<?>[] classArray2 = method.getParameterTypes();
        for (Class<?> clazz : classArray) {
            try {
                clazz.getMethod(string, classArray2);
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EventClient getEventClient() {
        if (this.initialized) {
            return this.client;
        }
        try {
            if (!this.lock.tryLock(3L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("can't acquire lock");
            }
            try {
                this.client = this.eventClientFactory.call();
                this.initialized = true;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Can't create EventClient: " + exception, exception);
        }
        return this.client;
    }

    protected EventClient createEventClient(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = EventClientDelegate.OBJECT_NAME;
        if (mBeanServerConnection.isRegistered(objectName)) {
            return new EventClient(mBeanServerConnection);
        }
        return null;
    }

    public static MBeanServerConnection getEventConnectionFor(MBeanServerConnection mBeanServerConnection, Callable<EventClient> callable) {
        if (mBeanServerConnection instanceof EventClientFactory && callable != null) {
            throw new IllegalArgumentException("connection already uses EventClient");
        }
        if (mBeanServerConnection instanceof EventClientFactory) {
            return mBeanServerConnection;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating EventClient for: " + mBeanServerConnection);
        }
        return EventClientConnection.newProxyInstance(mBeanServerConnection, MBeanServerConnection.class, callable);
    }

    private Object invokeEventClientSubscriberMethod(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.call(this, method, objectArray);
    }
}

