/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.ColorPanel;
import javax.swing.colorchooser.ValueFormatter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class SlidingSpinner
implements ChangeListener {
    private final ColorPanel panel;
    private final JComponent label;
    private final SpinnerNumberModel model = new SpinnerNumberModel();
    private final JSlider slider = new JSlider();
    private final JSpinner spinner = new JSpinner(this.model);
    private float value;
    private boolean internal;

    SlidingSpinner(ColorPanel colorPanel, JComponent jComponent) {
        this.panel = colorPanel;
        this.label = jComponent;
        this.slider.addChangeListener(this);
        this.spinner.addChangeListener(this);
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        ValueFormatter.init(3, false, defaultEditor.getTextField());
        defaultEditor.setFocusable(false);
        this.spinner.setFocusable(false);
    }

    JComponent getLabel() {
        return this.label;
    }

    JSlider getSlider() {
        return this.slider;
    }

    JSpinner getSpinner() {
        return this.spinner;
    }

    float getValue() {
        return this.value;
    }

    void setValue(float f) {
        int n = this.slider.getMinimum();
        int n2 = this.slider.getMaximum();
        this.internal = true;
        this.slider.setValue(n + (int)(f * (float)(n2 - n)));
        this.spinner.setValue(this.slider.getValue());
        this.internal = false;
        this.value = f;
    }

    void setRange(int n, int n2) {
        this.internal = true;
        this.slider.setMinimum(n);
        this.slider.setMaximum(n2);
        this.model.setMinimum(Integer.valueOf(n));
        this.model.setMaximum(Integer.valueOf(n2));
        this.internal = false;
    }

    void setVisible(boolean bl) {
        this.label.setVisible(bl);
        this.slider.setVisible(bl);
        this.spinner.setVisible(bl);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.internal) {
            Object object;
            if (this.spinner == changeEvent.getSource() && (object = this.spinner.getValue()) instanceof Integer) {
                this.internal = true;
                this.slider.setValue((Integer)object);
                this.internal = false;
            }
            int n = this.slider.getValue();
            this.internal = true;
            this.spinner.setValue(n);
            this.internal = false;
            int n2 = this.slider.getMinimum();
            int n3 = this.slider.getMaximum();
            this.value = (float)(n - n2) / (float)(n3 - n2);
            this.panel.colorChanged();
        }
    }
}

