/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.localization;

import com.sun.xml.internal.ws.util.localization.Localizable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private final Locale _locale;
    private final HashMap _resourceBundles;

    public Localizer() {
        this(Locale.getDefault());
    }

    public Localizer(Locale locale) {
        this._locale = locale;
        this._resourceBundles = new HashMap();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String localize(Localizable localizable) {
        String string = localizable.getResourceBundleName();
        try {
            String string2;
            Object[] objectArray;
            ResourceBundle resourceBundle = (ResourceBundle)this._resourceBundles.get(string);
            if (resourceBundle == null) {
                block13: {
                    try {
                        resourceBundle = ResourceBundle.getBundle(string, this._locale);
                    }
                    catch (MissingResourceException missingResourceException) {
                        int n = string.lastIndexOf(46);
                        if (n == -1) break block13;
                        objectArray = string.substring(n + 1);
                        try {
                            resourceBundle = ResourceBundle.getBundle((String)objectArray, this._locale);
                        }
                        catch (MissingResourceException missingResourceException2) {
                            return this.getDefaultMessage(localizable);
                        }
                    }
                }
                this._resourceBundles.put(string, resourceBundle);
            }
            if (resourceBundle == null) {
                return this.getDefaultMessage(localizable);
            }
            String string3 = localizable.getKey();
            if (string3 == Localizable.NOT_LOCALIZABLE) {
                return (String)localizable.getArguments()[0];
            }
            if (string3 == null) {
                string3 = "undefined";
            }
            try {
                string2 = resourceBundle.getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = resourceBundle.getString("undefined");
            }
            objectArray = localizable.getArguments();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Localizable)) continue;
                objectArray[i] = this.localize((Localizable)objectArray[i]);
            }
            String string4 = MessageFormat.format(string2, objectArray);
            return string4;
        }
        catch (MissingResourceException missingResourceException) {
            return this.getDefaultMessage(localizable);
        }
    }

    private String getDefaultMessage(Localizable localizable) {
        String string = localizable.getKey();
        Object[] objectArray = localizable.getArguments();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[failed to localize] ");
        stringBuilder.append(string);
        if (objectArray != null) {
            stringBuilder.append('(');
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(String.valueOf(objectArray[i]));
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

