/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.jvmstat.monitor.MonitorException;
import sun.tools.jstat.Alignment;
import sun.tools.jstat.Closure;
import sun.tools.jstat.ColumnFormat;

public class HeaderClosure
implements Closure {
    private static final char ALIGN_CHAR = '^';
    private StringBuilder header = new StringBuilder();

    public void visit(Object object, boolean bl) throws MonitorException {
        if (!(object instanceof ColumnFormat)) {
            return;
        }
        ColumnFormat columnFormat = (ColumnFormat)object;
        String string = columnFormat.getHeader();
        if (string.indexOf(94) >= 0) {
            int n = string.length();
            if (string.charAt(0) == '^' && string.charAt(n - 1) == '^') {
                columnFormat.setWidth(Math.max(columnFormat.getWidth(), Math.max(columnFormat.getFormat().length(), n - 2)));
                string = string.substring(1, n - 1);
                string = Alignment.CENTER.align(string, columnFormat.getWidth());
            } else if (string.charAt(0) == '^') {
                columnFormat.setWidth(Math.max(columnFormat.getWidth(), Math.max(columnFormat.getFormat().length(), n - 1)));
                string = string.substring(1, n);
                string = Alignment.LEFT.align(string, columnFormat.getWidth());
            } else if (string.charAt(n - 1) == '^') {
                columnFormat.setWidth(Math.max(columnFormat.getWidth(), Math.max(columnFormat.getFormat().length(), n - 1)));
                string = string.substring(0, n - 1);
                string = Alignment.RIGHT.align(string, columnFormat.getWidth());
            }
        }
        this.header.append(string);
        if (bl) {
            this.header.append(" ");
        }
    }

    public String getHeader() {
        return this.header.toString();
    }
}

