/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HotSpotAttachProvider
extends AttachProvider {
    private static final String JVM_VERSION = "java.property.java.vm.version";

    public void checkAttachPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AttachPermission("attachVirtualMachine"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        Set<Integer> set;
        MonitoredHost monitoredHost;
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        try {
            monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            set = monitoredHost.activeVms();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof ExceptionInInitializerError) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            if (throwable2 instanceof SecurityException) {
                return arrayList;
            }
            throw new InternalError();
        }
        for (Integer n : set) {
            String string;
            if (!(n instanceof Integer)) continue;
            String string2 = string = ((Object)n).toString();
            boolean bl = false;
            MonitoredVm monitoredVm = null;
            try {
                monitoredVm = monitoredHost.getMonitoredVm(new VmIdentifier(string));
                try {
                    bl = MonitoredVmUtil.isAttachable(monitoredVm);
                    string2 = MonitoredVmUtil.commandLine(monitoredVm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) continue;
                arrayList.add(new HotSpotVirtualMachineDescriptor(this, string, string2));
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) continue;
                throw (ThreadDeath)throwable;
            }
            finally {
                if (monitoredVm == null) continue;
                monitoredVm.detach();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAttachable(String string) throws AttachNotSupportedException {
        Object object;
        MonitoredVm monitoredVm = null;
        boolean bl = false;
        try {
            VmIdentifier vmIdentifier = new VmIdentifier(string);
            object = MonitoredHost.getMonitoredHost(vmIdentifier);
            monitoredVm = ((MonitoredHost)object).getMonitoredVm(vmIdentifier);
            if (MonitoredVmUtil.isAttachable(monitoredVm)) {
                return;
            }
            bl = MonitoredVmUtil.isKernelVM(monitoredVm);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                object = (ThreadDeath)throwable;
                throw object;
            }
            return;
        }
        finally {
            if (monitoredVm != null) {
                monitoredVm.detach();
            }
        }
        if (bl) {
            throw new AttachNotSupportedException("Kernel VM does not support the attach mechanism");
        }
        throw new AttachNotSupportedException("The VM does not support the attach mechanism");
    }

    static class HotSpotVirtualMachineDescriptor
    extends VirtualMachineDescriptor {
        HotSpotVirtualMachineDescriptor(AttachProvider attachProvider, String string, String string2) {
            super(attachProvider, string, string2);
        }

        public boolean isAttachable() {
            return true;
        }
    }
}

