/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackFrameImpl
extends MirrorImpl
implements StackFrame,
ThreadListener {
    private boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final long id;
    private final Location location;
    private Map<String, LocalVariable> visibleVariables = null;
    private ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine virtualMachine, ThreadReferenceImpl threadReferenceImpl, long l, Location location) {
        super(virtualMachine);
        this.thread = threadReferenceImpl;
        this.id = l;
        this.location = location;
        threadReferenceImpl.addListener(this);
    }

    @Override
    public boolean threadResumable(ThreadAction threadAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    @Override
    public Location location() {
        this.validateStackFrame();
        return this.location;
    }

    @Override
    public ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof StackFrameImpl) {
            StackFrameImpl stackFrameImpl = (StackFrameImpl)object;
            return this.id == stackFrameImpl.id && this.thread().equals(stackFrameImpl.thread()) && ((Object)this.location()).equals(stackFrameImpl.location()) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.thread().hashCode() << 4) + (int)this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl methodImpl = (MethodImpl)this.location.method();
        if (methodImpl.isStatic() || methodImpl.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            PacketStream packetStream;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.validateStackFrame();
                packetStream = JDWP.StackFrame.ThisObject.enqueueCommand(this.vm, this.thread, this.id);
            }
            try {
                this.thisObject = JDWP.StackFrame.ThisObject.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)packetStream).objectThis;
            }
            catch (JDWPException jDWPException) {
                switch (jDWPException.errorCode()) {
                    case 10: 
                    case 13: 
                    case 30: {
                        throw new InvalidStackFrameException();
                    }
                }
                throw jDWPException.toJDIException();
            }
        }
        return this.thisObject;
    }

    private void createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            List<LocalVariable> list = this.location.method().variables();
            HashMap<String, LocalVariable> hashMap = new HashMap<String, LocalVariable>(list.size());
            for (LocalVariable localVariable : list) {
                LocalVariable localVariable2;
                String string = localVariable.name();
                if (!localVariable.isVisible(this) || (localVariable2 = (LocalVariable)hashMap.get(string)) != null && !((LocalVariableImpl)localVariable).hides(localVariable2)) continue;
                hashMap.put(string, localVariable);
            }
            this.visibleVariables = hashMap;
        }
    }

    @Override
    public List<LocalVariable> visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(this.visibleVariables.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public LocalVariable visibleVariableByName(String string) throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        return this.visibleVariables.get(string);
    }

    @Override
    public Value getValue(LocalVariable localVariable) {
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(1);
        arrayList.add(localVariable);
        return this.getValues(arrayList).get(localVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<LocalVariable, Value> getValues(List<? extends LocalVariable> list) {
        PacketStream packetStream;
        Object object;
        this.validateStackFrame();
        this.validateMirrors(list);
        int n = list.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.GetValues.SlotInfo[n];
        for (int i = 0; i < n; ++i) {
            object = (LocalVariableImpl)list.get(i);
            if (!object.isVisible(this)) {
                throw new IllegalArgumentException(object.name() + " is not valid at this frame location");
            }
            slotInfoArray[i] = new JDWP.StackFrame.GetValues.SlotInfo(object.slot(), (byte)object.signature().charAt(0));
        }
        object = this.vm.state();
        synchronized (object) {
            this.validateStackFrame();
            packetStream = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slotInfoArray);
        }
        try {
            object = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)packetStream).values;
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw jDWPException.toJDIException();
        }
        if (n != ((ValueImpl[])object).length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        HashMap<LocalVariable, Value> hashMap = new HashMap<LocalVariable, Value>(n);
        for (int i = 0; i < n; ++i) {
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)list.get(i);
            hashMap.put(localVariableImpl, object[i]);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(LocalVariable localVariable, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block11: {
            this.validateStackFrame();
            this.validateMirror(localVariable);
            this.validateMirrorOrNull(value);
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
            ValueImpl valueImpl = (ValueImpl)value;
            if (!localVariableImpl.isVisible(this)) {
                throw new IllegalArgumentException(localVariableImpl.name() + " is not valid at this frame location");
            }
            try {
                PacketStream packetStream;
                valueImpl = ValueImpl.prepareForAssignment(valueImpl, localVariableImpl);
                JDWP.StackFrame.SetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(localVariableImpl.slot(), valueImpl)};
                VMState vMState = this.vm.state();
                synchronized (vMState) {
                    this.validateStackFrame();
                    packetStream = JDWP.StackFrame.SetValues.enqueueCommand(this.vm, this.thread, this.id, slotInfoArray);
                }
                try {
                    JDWP.StackFrame.SetValues.waitForReply(this.vm, packetStream);
                }
                catch (JDWPException jDWPException) {
                    switch (jDWPException.errorCode()) {
                        case 10: 
                        case 13: 
                        case 30: {
                            throw new InvalidStackFrameException();
                        }
                    }
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (valueImpl == null) break block11;
                throw classNotLoadedException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> getArgumentValues() {
        PacketStream packetStream;
        this.validateStackFrame();
        MethodImpl methodImpl = (MethodImpl)this.location.method();
        List<String> list = methodImpl.argumentSignatures();
        int n = list.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.GetValues.SlotInfo[n];
        int n2 = methodImpl.isStatic() ? 0 : 1;
        for (int i = 0; i < n; ++i) {
            char c = list.get(i).charAt(0);
            slotInfoArray[i] = new JDWP.StackFrame.GetValues.SlotInfo(n2++, (byte)c);
            if (c != 'J' && c != 'D') continue;
            ++n2;
        }
        ValueImpl[] valueImplArray = this.vm.state();
        synchronized (valueImplArray) {
            this.validateStackFrame();
            packetStream = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slotInfoArray);
        }
        try {
            valueImplArray = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)packetStream).values;
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw jDWPException.toJDIException();
        }
        if (n != valueImplArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        return Arrays.asList((Value[])valueImplArray);
    }

    void pop() throws IncompatibleThreadStateException {
        this.validateStackFrame();
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.StackFrame.PopFrames.enqueueCommand(StackFrameImpl.this.vm, StackFrameImpl.this.thread, StackFrameImpl.this.id);
            }
        };
        try {
            PacketStream packetStream = this.thread.sendResumingCommand(commandSender);
            JDWP.StackFrame.PopFrames.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not current or suspended");
                }
                case 10: {
                    throw new IncompatibleThreadStateException("zombie");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw jDWPException.toJDIException();
        }
        this.vm.state().freeze();
    }

    @Override
    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

