/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.DisassemblerTool;
import com.sun.tools.javap.InternalError;
import com.sun.tools.javap.JavapFileManager;
import com.sun.tools.javap.Options;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavapTask
implements DisassemblerTool.DisassemblerTask {
    static Option[] recognizedOptions = new Option[]{new Option(false, new String[]{"-help", "--help", "-?"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.help = true;
        }
    }, new Option(false, new String[]{"-version"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.version = true;
        }
    }, new Option(false, new String[]{"-fullversion"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.fullVersion = true;
        }
    }, new Option(false, new String[]{"-v", "-verbose", "-all"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.verbose = true;
            javapTask.options.showFlags = true;
            javapTask.options.showAllAttrs = true;
        }
    }, new Option(false, new String[]{"-l"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showLineAndLocalVariableTables = true;
        }
    }, new Option(false, new String[]{"-public"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 1;
        }
    }, new Option(false, new String[]{"-protected"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 4;
        }
    }, new Option(false, new String[]{"-package"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 0;
        }
    }, new Option(false, new String[]{"-p", "-private"}){

        void process(JavapTask javapTask, String string, String string2) {
            if (!javapTask.options.accessOptions.contains("-p") && !javapTask.options.accessOptions.contains("-private")) {
                javapTask.options.accessOptions.add(string);
            }
            javapTask.options.showAccess = 2;
        }
    }, new Option(false, new String[]{"-c"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showDisassembled = true;
        }
    }, new Option(false, new String[]{"-s"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showInternalSignatures = true;
        }
    }, new Option(false, new String[]{"-h"}){

        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            JavapTask javapTask2 = javapTask;
            javapTask2.getClass();
            throw javapTask2.new BadArgs("err.h.not.supported", new Object[0]);
        }
    }, new Option(false, new String[]{"-verify", "-verify-verbose"}){

        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            JavapTask javapTask2 = javapTask;
            javapTask2.getClass();
            throw javapTask2.new BadArgs("err.verify.not.supported", new Object[0]);
        }
    }, new Option(false, new String[]{"-sysinfo"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.sysInfo = true;
        }
    }, new Option(false, new String[]{"-Xold"}){

        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            JavapTask javapTask2 = javapTask;
            javapTask2.getClass();
            throw javapTask2.new BadArgs("err.Xold.not.supported.here", new Object[0]);
        }
    }, new Option(false, new String[]{"-Xnew"}){

        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
        }
    }, new Option(false, new String[]{"-XDcompat"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.compat = true;
        }
    }, new Option(false, new String[]{"-XDjsr277"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.jsr277 = true;
        }
    }, new Option(false, new String[]{"-XDignore.symbol.file"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.ignoreSymbolFile = true;
        }
    }, new Option(false, new String[]{"-constants"}){

        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showConstants = true;
        }
    }};
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private static final String versionRBName = "com.sun.tools.javap.resources.version";
    private static ResourceBundle versionRB;
    Context context = new Context();
    JavaFileManager fileManager;
    PrintWriter log;
    DiagnosticListener<? super JavaFileObject> diagnosticListener;
    List<String> classes;
    Options options = Options.instance(this.context);
    Locale task_locale;
    Map<Locale, ResourceBundle> bundles;
    private static final String progname = "javap";

    JavapTask() {
    }

    JavapTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2) {
        this();
        this.log = JavapTask.getPrintWriterForWriter(writer);
        this.fileManager = javaFileManager;
        this.diagnosticListener = diagnosticListener;
        try {
            this.handleOptions(iterable, false);
        }
        catch (BadArgs badArgs) {
            throw new IllegalArgumentException(badArgs.getMessage());
        }
        this.classes = new ArrayList<String>();
        for (String string : iterable2) {
            string.getClass();
            this.classes.add(string);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.task_locale = locale;
    }

    public void setLog(PrintWriter printWriter) {
        this.log = printWriter;
    }

    public void setLog(OutputStream outputStream) {
        this.setLog(JavapTask.getPrintWriterForStream(outputStream));
    }

    private static PrintWriter getPrintWriterForStream(OutputStream outputStream) {
        return new PrintWriter(outputStream, true);
    }

    private static PrintWriter getPrintWriterForWriter(Writer writer) {
        if (writer == null) {
            return JavapTask.getPrintWriterForStream(null);
        }
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(writer, true);
    }

    public void setDiagnosticListener(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
    }

    public void setDiagnosticListener(OutputStream outputStream) {
        this.setDiagnosticListener(this.getDiagnosticListenerForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForStream(OutputStream outputStream) {
        return this.getDiagnosticListenerForWriter(JavapTask.getPrintWriterForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForWriter(Writer writer) {
        final PrintWriter printWriter = JavapTask.getPrintWriterForWriter(writer);
        return new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    printWriter.print(JavapTask.this.getMessage("err.prefix", new Object[0]));
                    printWriter.print(" ");
                }
                printWriter.println(diagnostic.getMessage(null));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) {
        try {
            this.handleOptions(stringArray);
            if (this.classes == null || this.classes.size() == 0) {
                if (this.options.help || this.options.version || this.options.fullVersion) {
                    int n = 0;
                    return n;
                }
                int n = 2;
                return n;
            }
            boolean bl = this.run();
            int n = bl ? 0 : 1;
            return n;
        }
        catch (BadArgs badArgs) {
            this.diagnosticListener.report(this.createDiagnostic(badArgs.key, badArgs.args));
            if (badArgs.showUsage) {
                this.log.println(this.getMessage("main.usage.summary", progname));
            }
            int n = 2;
            return n;
        }
        catch (InternalError internalError) {
            Object[] objectArray;
            if (internalError.getCause() == null) {
                objectArray = internalError.args;
            } else {
                objectArray = new Object[internalError.args.length + 1];
                objectArray[0] = internalError.getCause();
                System.arraycopy(internalError.args, 0, objectArray, 1, internalError.args.length);
            }
            this.diagnosticListener.report(this.createDiagnostic("err.internal.error", objectArray));
            int n = 4;
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    public void handleOptions(String[] stringArray) throws BadArgs {
        this.handleOptions(Arrays.asList(stringArray), true);
    }

    private void handleOptions(Iterable<String> iterable, boolean bl) throws BadArgs {
        CharSequence charSequence;
        Iterator<String> iterator;
        boolean bl2;
        if (this.log == null) {
            this.log = JavapTask.getPrintWriterForStream(System.out);
            if (this.diagnosticListener == null) {
                this.diagnosticListener = this.getDiagnosticListenerForStream(System.err);
            }
        } else if (this.diagnosticListener == null) {
            this.diagnosticListener = this.getDiagnosticListenerForWriter(this.log);
        }
        if (this.fileManager == null) {
            this.fileManager = this.getDefaultFileManager(this.diagnosticListener, this.log);
        }
        boolean bl3 = bl2 = !(iterator = iterable.iterator()).hasNext();
        while (iterator.hasNext()) {
            charSequence = iterator.next();
            if (((String)charSequence).startsWith("-")) {
                this.handleOption((String)charSequence, iterator);
                continue;
            }
            if (bl) {
                if (this.classes == null) {
                    this.classes = new ArrayList<String>();
                }
                this.classes.add((String)charSequence);
                while (iterator.hasNext()) {
                    this.classes.add(iterator.next());
                }
                continue;
            }
            throw new BadArgs("err.unknown.option", charSequence).showUsage(true);
        }
        if (!this.options.compat && this.options.accessOptions.size() > 1) {
            charSequence = new StringBuilder();
            for (String string : this.options.accessOptions) {
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(" ");
                }
                ((StringBuilder)charSequence).append(string);
            }
            throw new BadArgs("err.incompatible.options", charSequence);
        }
        if (this.options.ignoreSymbolFile && this.fileManager instanceof JavapFileManager) {
            ((JavapFileManager)this.fileManager).setIgnoreSymbolFile(true);
        }
        if (!(this.classes != null && this.classes.size() != 0 || bl2 || this.options.help || this.options.version || this.options.fullVersion)) {
            throw new BadArgs("err.no.classes.specified", new Object[0]);
        }
        if (bl2 || this.options.help) {
            this.showHelp();
        }
        if (this.options.version || this.options.fullVersion) {
            this.showVersion(this.options.fullVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOption(String string, Iterator<String> iterator) throws BadArgs {
        for (Option option : recognizedOptions) {
            if (!option.matches(string)) continue;
            if (option.hasArg) {
                if (!iterator.hasNext()) throw new BadArgs("err.missing.arg", string).showUsage(true);
                option.process(this, string, iterator.next());
            } else {
                option.process(this, string, null);
            }
            if (!option.ignoreRest()) return;
            while (iterator.hasNext()) {
                iterator.next();
            }
            return;
        }
        if (!this.fileManager.handleOption(string, iterator)) throw new BadArgs("err.unknown.option", string).showUsage(true);
    }

    @Override
    public Boolean call() {
        return this.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run() {
        if (this.classes == null || this.classes.size() == 0) {
            return false;
        }
        this.context.put(PrintWriter.class, this.log);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        boolean bl = true;
        Iterator<String> iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            Closeable closeable;
            String string = iterator.next();
            try {
                JavaFileObject javaFileObject;
                Object object;
                block18: {
                    if (string.endsWith(".class")) {
                        if (this.fileManager instanceof StandardJavaFileManager) {
                            object = (StandardJavaFileManager)this.fileManager;
                            javaFileObject = object.getJavaFileObjects(string).iterator().next();
                            break block18;
                        } else {
                            this.diagnosticListener.report(this.createDiagnostic("err.not.standard.file.manager", string));
                            bl = false;
                            continue;
                        }
                    }
                    javaFileObject = this.getClassFileObject(string);
                    if (javaFileObject == null) {
                        int n;
                        object = string;
                        while (javaFileObject == null && (n = ((String)object).lastIndexOf(".")) != -1) {
                            object = ((String)object).substring(0, n) + "$" + ((String)object).substring(n + 1);
                            javaFileObject = this.getClassFileObject((String)object);
                        }
                    }
                    if (javaFileObject == null) {
                        this.diagnosticListener.report(this.createDiagnostic("err.class.not.found", string));
                        bl = false;
                        continue;
                    }
                }
                object = new Attribute.Factory();
                ((Attribute.Factory)object).setCompat(this.options.compat);
                ((Attribute.Factory)object).setJSR277(this.options.jsr277);
                InputStream inputStream = javaFileObject.openInputStream();
                closeable = null;
                MessageDigest messageDigest = null;
                if (this.options.sysInfo || this.options.verbose) {
                    messageDigest = MessageDigest.getInstance("MD5");
                    inputStream = new DigestInputStream(inputStream, messageDigest);
                    closeable = new SizeInputStream(inputStream);
                    inputStream = closeable;
                }
                ClassFile classFile = ClassFile.read(inputStream, (Attribute.Factory)object);
                if (this.options.sysInfo || this.options.verbose) {
                    classWriter.setFile(javaFileObject.toUri());
                    classWriter.setLastModified(javaFileObject.getLastModified());
                    classWriter.setDigest("MD5", messageDigest.digest());
                    classWriter.setFileSize(((SizeInputStream)closeable).size());
                }
                classWriter.write(classFile);
            }
            catch (ConstantPoolException constantPoolException) {
                this.diagnosticListener.report(this.createDiagnostic("err.bad.constant.pool", string, constantPoolException.getLocalizedMessage()));
                bl = false;
            }
            catch (EOFException eOFException) {
                this.diagnosticListener.report(this.createDiagnostic("err.end.of.file", string));
                bl = false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.diagnosticListener.report(this.createDiagnostic("err.file.not.found", fileNotFoundException.getLocalizedMessage()));
                bl = false;
            }
            catch (IOException iOException) {
                Object object = iOException.getLocalizedMessage();
                if (object == null) {
                    object = iOException;
                }
                this.diagnosticListener.report(this.createDiagnostic("err.ioerror", string, object));
                bl = false;
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                closeable = new PrintWriter(stringWriter);
                throwable.printStackTrace((PrintWriter)closeable);
                ((PrintWriter)closeable).close();
                this.diagnosticListener.report(this.createDiagnostic("err.crash", throwable.toString(), stringWriter.toString()));
                bl = false;
                continue;
            }
            break;
        }
        return bl;
    }

    private JavaFileManager getDefaultFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, PrintWriter printWriter) {
        return JavapFileManager.create(diagnosticListener, printWriter, this.options);
    }

    private JavaFileObject getClassFileObject(String string) throws IOException {
        JavaFileObject javaFileObject = this.fileManager.getJavaFileForInput(StandardLocation.PLATFORM_CLASS_PATH, string, JavaFileObject.Kind.CLASS);
        if (javaFileObject == null) {
            javaFileObject = this.fileManager.getJavaFileForInput(StandardLocation.CLASS_PATH, string, JavaFileObject.Kind.CLASS);
        }
        return javaFileObject;
    }

    private void showHelp() {
        this.log.println(this.getMessage("main.usage", progname));
        Object[] objectArray = recognizedOptions;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Option option = objectArray[i];
            Object object = option.aliases[0].substring(1);
            if (((String)object).startsWith("X") || ((String)object).equals("fullversion") || ((String)object).equals("h") || ((String)object).equals("verify")) continue;
            this.log.println(this.getMessage("main.opt." + (String)object, new Object[0]));
        }
        for (Object object : objectArray = new String[]{"-classpath", "-bootclasspath"}) {
            if (this.fileManager.isSupportedOption((String)object) == -1) continue;
            String string = ((String)object).substring(1);
            this.log.println(this.getMessage("main.opt." + string, new Object[0]));
        }
    }

    private void showVersion(boolean bl) {
        this.log.println(this.version(bl ? "full" : "release"));
    }

    private String version(String string) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException missingResourceException) {
                return this.getMessage("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return versionRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return this.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final String string, final Object ... objectArray) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public Diagnostic.Kind getKind() {
                return Diagnostic.Kind.ERROR;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return string;
            }

            @Override
            public String getMessage(Locale locale) {
                return JavapTask.this.getMessage(locale, string, objectArray);
            }
        };
    }

    private String getMessage(String string, Object ... objectArray) {
        return this.getMessage(this.task_locale, string, objectArray);
    }

    private String getMessage(Locale locale, String string, Object ... objectArray) {
        ResourceBundle resourceBundle;
        if (this.bundles == null) {
            this.bundles = new HashMap<Locale, ResourceBundle>();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((resourceBundle = this.bundles.get(locale)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sun.tools.javap.resources.javap", locale);
                this.bundles.put(locale, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError(new Object[]{"Cannot find javap resource bundle for locale " + locale});
            }
        }
        try {
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new InternalError(missingResourceException, string);
        }
    }

    private static class SizeInputStream
    extends FilterInputStream {
        private int size;

        SizeInputStream(InputStream inputStream) {
            super(inputStream);
        }

        int size() {
            return this.size;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                this.size += n3;
            }
            return n3;
        }

        public int read() throws IOException {
            int n = super.read();
            ++this.size;
            return n;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean bl, String ... stringArray) {
            this.hasArg = bl;
            this.aliases = stringArray;
        }

        boolean matches(String string) {
            for (String string2 : this.aliases) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JavapTask var1, String var2, String var3) throws BadArgs;
    }

    public class BadArgs
    extends Exception {
        static final long serialVersionUID = 8765093759964640721L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String string, Object ... objectArray) {
            super(JavapTask.this.getMessage(string, objectArray));
            this.key = string;
            this.args = objectArray;
        }

        BadArgs showUsage(boolean bl) {
            this.showUsage = bl;
            return this;
        }
    }
}

