/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.addon.at_generated;

import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.tools.internal.xjc.Driver;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.outline.ClassOutline;
import com.sun.tools.internal.xjc.outline.EnumOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.ErrorHandler;

public class PluginImpl
extends Plugin {
    private JClass annotation;
    private String date = null;

    public String getOptionName() {
        return "mark-generated";
    }

    public String getUsage() {
        return "  -mark-generated    :  mark the generated code as @javax.annotation.Generated";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        this.annotation = outline.getCodeModel().ref("javax.annotation.Generated");
        for (ClassOutline object : outline.getClasses()) {
            this.augument(object);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.augument(enumOutline);
        }
        return true;
    }

    private void augument(EnumOutline enumOutline) {
        this.annotate(enumOutline.clazz);
    }

    private void augument(ClassOutline classOutline) {
        this.annotate(classOutline.implClass);
        for (JMethod jAnnotatable : classOutline.implClass.methods()) {
            this.annotate(jAnnotatable);
        }
        for (JFieldVar jFieldVar : classOutline.implClass.fields().values()) {
            this.annotate(jFieldVar);
        }
    }

    private void annotate(JAnnotatable jAnnotatable) {
        jAnnotatable.annotate(this.annotation).param("value", Driver.class.getName()).param("date", this.getISO8601Date()).param("comment", "JAXB RI v" + Options.getBuildID());
    }

    private String getISO8601Date() {
        if (this.date == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ").format(new Date()));
            stringBuffer.insert(stringBuffer.length() - 2, ':');
            this.date = stringBuffer.toString();
        }
        return this.date;
    }
}

