/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEConstants;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEContent;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEPart;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEXml;
import com.sun.tools.internal.ws.wsdl.framework.Extensible;
import com.sun.tools.internal.ws.wsdl.framework.Extension;
import com.sun.tools.internal.ws.wsdl.framework.ParserContext;
import com.sun.tools.internal.ws.wsdl.framework.WriterContext;
import com.sun.tools.internal.ws.wsdl.parser.ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class MIMEExtensionHandler
extends ExtensionHandler {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/mime/";
    }

    public boolean doHandleExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (extensible.getElementName().equals(WSDLConstants.QNAME_OUTPUT)) {
            return this.handleInputOutputExtension(parserContext, extensible, element);
        }
        if (extensible.getElementName().equals(WSDLConstants.QNAME_INPUT)) {
            return this.handleInputOutputExtension(parserContext, extensible, element);
        }
        if (extensible.getElementName().equals(MIMEConstants.QNAME_PART)) {
            return this.handleMIMEPartExtension(parserContext, extensible, element);
        }
        parserContext.fireIgnoringExtension(new QName(element.getNamespaceURI(), element.getLocalName()), extensible.getElementName());
        return false;
    }

    protected boolean handleInputOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MULTIPART_RELATED)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            MIMEMultipartRelated mIMEMultipartRelated = new MIMEMultipartRelated();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, MIMEConstants.QNAME_PART)) {
                    Element element3;
                    parserContext.push();
                    parserContext.registerNamespaces(element2);
                    MIMEPart mIMEPart = new MIMEPart();
                    String string = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                    if (string != null) {
                        mIMEPart.setName(string);
                    }
                    Iterator iterator2 = XmlUtil.getAllChildren((Element)element2);
                    while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                        ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(element3.getNamespaceURI());
                        boolean bl = false;
                        if (extensionHandler != null) {
                            bl = extensionHandler.doHandleExtension(parserContext, mIMEPart, element3);
                        }
                        if (bl) continue;
                        String string2 = XmlUtil.getAttributeNSOrNull((Element)element3, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/");
                        if (string2 != null && string2.equals("true")) {
                            Util.fail("parsing.requiredExtensibilityElement", element3.getTagName(), element3.getNamespaceURI());
                            continue;
                        }
                        parserContext.fireIgnoringExtension(new QName(element3.getNamespaceURI(), element3.getLocalName()), mIMEPart.getElementName());
                    }
                    mIMEMultipartRelated.add(mIMEPart);
                    parserContext.pop();
                    parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_PART, mIMEPart);
                    continue;
                }
                Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
            }
            extensible.addExtension(mIMEMultipartRelated);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_MULTIPART_RELATED, mIMEMultipartRelated);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(parserContext, element);
            extensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(parserContext, element);
            extensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(parserContext, element);
            extensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(parserContext, element);
            extensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected MIMEContent parseMIMEContent(ParserContext parserContext, Element element) {
        String string;
        parserContext.push();
        parserContext.registerNamespaces(element);
        MIMEContent mIMEContent = new MIMEContent();
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        if (string2 != null) {
            mIMEContent.setPart(string2);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"type")) != null) {
            mIMEContent.setType(string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_CONTENT, mIMEContent);
        return mIMEContent;
    }

    protected MIMEXml parseMIMEXml(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        MIMEXml mIMEXml = new MIMEXml();
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        if (string != null) {
            mIMEXml.setPart(string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(MIMEConstants.QNAME_MIME_XML, mIMEXml);
        return mIMEXml;
    }

    public void doHandleExtension(WriterContext writerContext, Extension extension) throws IOException {
        if (extension instanceof MIMEContent) {
            MIMEContent mIMEContent = (MIMEContent)extension;
            writerContext.writeStartTag(mIMEContent.getElementName());
            writerContext.writeAttribute("part", mIMEContent.getPart());
            writerContext.writeAttribute("type", mIMEContent.getType());
            writerContext.writeEndTag(mIMEContent.getElementName());
        } else if (extension instanceof MIMEXml) {
            MIMEXml mIMEXml = (MIMEXml)extension;
            writerContext.writeStartTag(mIMEXml.getElementName());
            writerContext.writeAttribute("part", mIMEXml.getPart());
            writerContext.writeEndTag(mIMEXml.getElementName());
        } else if (extension instanceof MIMEMultipartRelated) {
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)extension;
            writerContext.writeStartTag(mIMEMultipartRelated.getElementName());
            Iterator<MIMEPart> iterator = mIMEMultipartRelated.getParts();
            while (iterator.hasNext()) {
                MIMEPart mIMEPart = iterator.next();
                writerContext.writeStartTag(mIMEPart.getElementName());
                Iterator iterator2 = mIMEPart.extensions();
                while (iterator2.hasNext()) {
                    Extension extension2 = (Extension)iterator2.next();
                    ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(extension2.getElementName().getNamespaceURI());
                    if (extensionHandler == null) continue;
                    extensionHandler.doHandleExtension(writerContext, extension2);
                }
                writerContext.writeEndTag(mIMEPart.getElementName());
            }
            writerContext.writeEndTag(mIMEMultipartRelated.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

