/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.util;

import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.localization.Localizer;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class ToolBase {
    protected OutputStream out;
    protected String program;
    protected Localizer localizer;
    protected LocalizableMessageFactory messageFactory;
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";

    public ToolBase(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
        this.initialize();
    }

    protected void initialize() {
        this.messageFactory = new LocalizableMessageFactory(this.getResourceBundleName());
        this.localizer = new Localizer();
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        try {
            this.run();
            return this.wasSuccessful();
        }
        catch (Exception exception) {
            if (exception instanceof Localizable) {
                this.report((Localizable)exception);
            } else {
                this.report(this.getMessage(this.getGenericErrorMessage(), exception.toString()));
            }
            this.printStackTrace(exception);
            return false;
        }
    }

    public boolean wasSuccessful() {
        return true;
    }

    protected abstract boolean parseArguments(String[] var1);

    protected abstract void run() throws Exception;

    public void runProcessorActions() {
    }

    protected abstract String getGenericErrorMessage();

    protected abstract String getResourceBundleName();

    public void printStackTrace(Throwable throwable) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        throwable.printStackTrace(printStream);
        printStream.flush();
    }

    protected void report(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
        printStream.flush();
    }

    protected void report(Localizable localizable) {
        this.report(this.localizer.localize(localizable));
    }

    public Localizable getMessage(String string) {
        return this.getMessage(string, (Object[])null);
    }

    public Localizable getMessage(String string, String string2) {
        return this.messageFactory.getMessage(string, new Object[]{string2});
    }

    public Localizable getMessage(String string, String string2, String string3) {
        return this.messageFactory.getMessage(string, new Object[]{string2, string3});
    }

    public Localizable getMessage(String string, String string2, String string3, String string4) {
        return this.messageFactory.getMessage(string, new Object[]{string2, string3, string4});
    }

    public Localizable getMessage(String string, Localizable localizable) {
        return this.messageFactory.getMessage(string, new Object[]{localizable});
    }

    public Localizable getMessage(String string, Object[] objectArray) {
        return this.messageFactory.getMessage(string, objectArray);
    }
}

