/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.ProcessorAction;
import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.processor.generator.GeneratorConstants;
import com.sun.tools.internal.ws.processor.generator.GeneratorException;
import com.sun.tools.internal.ws.processor.generator.JAXBTypeGenerator;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.AbstractType;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Request;
import com.sun.tools.internal.ws.processor.model.Response;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBTypeVisitor;
import com.sun.tools.internal.ws.processor.model.jaxb.RpcLitStructure;
import com.sun.tools.internal.ws.processor.util.DirectoryUtil;
import com.sun.tools.internal.ws.processor.util.GeneratedFileInfo;
import com.sun.tools.internal.ws.processor.util.IndentingWriter;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.xml.internal.ws.encoding.soap.SOAPVersion;
import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jws.HandlerChain;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements GeneratorConstants,
ProcessorAction,
ModelVisitor,
JAXBTypeVisitor {
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected ProcessorEnvironment env;
    protected Model model;
    protected Service service;
    protected SOAPVersion curSOAPVersion;
    protected String targetVersion;
    protected boolean donotOverride;
    protected String servicePackage;
    protected JCodeModel cm;
    protected boolean printStackTrace;
    protected String wsdlLocation;
    private LocalizableMessageFactory messageFactory;

    public GeneratorBase() {
        this.sourceDir = null;
        this.destDir = null;
        this.nonclassDestDir = null;
        this.env = null;
        this.model = null;
    }

    @Override
    public void perform(Model model, Configuration configuration, Properties properties) {
        GeneratorBase generatorBase = this.getGenerator(model, configuration, properties);
        generatorBase.doGeneration();
    }

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3);

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3, SOAPVersion var4);

    protected GeneratorBase(Model model, Configuration configuration, Properties properties) {
        this.model = model;
        this.cm = model.getJAXBModel().getS2JJAXBModel() != null ? model.getJAXBModel().getS2JJAXBModel().generateCode(null, new JAXBTypeGenerator.JAXBErrorListener()) : new JCodeModel();
        this.env = configuration.getEnvironment();
        String string = "destinationDirectory";
        String string2 = properties.getProperty(string);
        this.destDir = new File(string2);
        string = "sourceDirectory";
        String string3 = properties.getProperty(string);
        this.sourceDir = new File(string3);
        string = "nonclassDestinationDirectory";
        String string4 = properties.getProperty(string);
        this.nonclassDestDir = new File(string4);
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        this.messageFactory = new LocalizableMessageFactory("com.sun.tools.internal.ws.resources.generator");
        this.targetVersion = properties.getProperty("sourceVersion");
        string = "doNotOverWrite";
        this.donotOverride = Boolean.valueOf(properties.getProperty(string));
        this.printStackTrace = Boolean.valueOf(properties.getProperty("printStackTrace"));
        this.wsdlLocation = properties.getProperty("wsdllocation");
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception exception) {
            if (this.env.verbose()) {
                exception.printStackTrace();
            }
            throw new GeneratorException("generator.nestedGeneratorError", exception);
        }
    }

    @Override
    public void visit(Model model) throws Exception {
        this.preVisitModel(model);
        this.visitModel(model);
        this.postVisitModel(model);
    }

    protected void preVisitModel(Model model) throws Exception {
    }

    protected void visitModel(Model model) throws Exception {
        this.env.getNames().resetPrefixFactory();
        for (Service service : model.getServices()) {
            service.accept(this);
        }
    }

    protected void postVisitModel(Model model) throws Exception {
    }

    @Override
    public void visit(Service service) throws Exception {
        this.preVisitService(service);
        this.visitService(service);
        this.postVisitService(service);
    }

    protected void preVisitService(Service service) throws Exception {
        this.servicePackage = Names.getPackageName(service);
    }

    protected void visitService(Service service) throws Exception {
        this.service = service;
        for (Port port : service.getPorts()) {
            port.accept(this);
        }
        this.service = null;
    }

    protected void postVisitService(Service service) throws Exception {
        Iterator iterator = this.model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
        }
        this.servicePackage = null;
    }

    @Override
    public void visit(Port port) throws Exception {
        this.preVisitPort(port);
        this.visitPort(port);
        this.postVisitPort(port);
    }

    protected void preVisitPort(Port port) throws Exception {
        this.curSOAPVersion = port.getSOAPVersion();
    }

    protected void visitPort(Port port) throws Exception {
        for (Operation operation : port.getOperations()) {
            operation.accept(this);
        }
    }

    protected void postVisitPort(Port port) throws Exception {
        this.curSOAPVersion = null;
    }

    @Override
    public void visit(Operation operation) throws Exception {
        this.preVisitOperation(operation);
        this.visitOperation(operation);
        this.postVisitOperation(operation);
    }

    protected void preVisitOperation(Operation operation) throws Exception {
    }

    protected void visitOperation(Operation operation) throws Exception {
        Iterator<Fault> iterator;
        operation.getRequest().accept(this);
        if (operation.getResponse() != null) {
            operation.getResponse().accept(this);
        }
        if ((iterator = operation.getFaultsSet().iterator()) != null) {
            while (iterator.hasNext()) {
                Fault fault = iterator.next();
                fault.accept(this);
            }
        }
    }

    protected void postVisitOperation(Operation operation) throws Exception {
    }

    @Override
    public void visit(Parameter parameter) throws Exception {
        this.preVisitParameter(parameter);
        this.visitParameter(parameter);
        this.postVisitParameter(parameter);
    }

    protected void preVisitParameter(Parameter parameter) throws Exception {
    }

    protected void visitParameter(Parameter parameter) throws Exception {
    }

    protected void postVisitParameter(Parameter parameter) throws Exception {
    }

    @Override
    public void visit(Block block) throws Exception {
        this.preVisitBlock(block);
        this.visitBlock(block);
        this.postVisitBlock(block);
    }

    protected void preVisitBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
    }

    protected void postVisitBlock(Block block) throws Exception {
    }

    @Override
    public void visit(Response response) throws Exception {
        this.preVisitResponse(response);
        this.visitResponse(response);
        this.postVisitResponse(response);
    }

    protected void preVisitResponse(Response response) throws Exception {
    }

    protected void visitResponse(Response response) throws Exception {
        AbstractType abstractType;
        Block block;
        Iterator<ModelObject> iterator = response.getParameters();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
        iterator = response.getBodyBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType instanceof JAXBType) {
                ((JAXBType)abstractType).accept(this);
            } else if (abstractType instanceof RpcLitStructure) {
                ((RpcLitStructure)abstractType).accept(this);
            }
            this.responseBodyBlock(block);
        }
        iterator = response.getHeaderBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType instanceof JAXBType) {
                ((JAXBType)abstractType).accept(this);
            }
            this.responseHeaderBlock(block);
        }
        iterator = response.getAttachmentBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType instanceof JAXBType) {
                ((JAXBType)abstractType).accept(this);
            }
            this.responseAttachmentBlock(block);
        }
    }

    protected void responseBodyBlock(Block block) throws Exception {
    }

    protected void responseHeaderBlock(Block block) throws Exception {
    }

    protected void responseAttachmentBlock(Block block) throws Exception {
    }

    protected void postVisitResponse(Response response) throws Exception {
    }

    @Override
    public void visit(Request request) throws Exception {
        this.preVisitRequest(request);
        this.visitRequest(request);
        this.postVisitRequest(request);
    }

    protected void preVisitRequest(Request request) throws Exception {
    }

    protected void visitRequest(Request request) throws Exception {
        AbstractType abstractType;
        Block block;
        Iterator<ModelObject> iterator = request.getParameters();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
        iterator = request.getBodyBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType instanceof JAXBType) {
                ((JAXBType)abstractType).accept(this);
            } else if (abstractType instanceof RpcLitStructure) {
                ((RpcLitStructure)abstractType).accept(this);
            }
            this.requestBodyBlock(block);
        }
        iterator = request.getHeaderBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType instanceof JAXBType) {
                ((JAXBType)abstractType).accept(this);
            }
            this.requestHeaderBlock(block);
        }
    }

    protected void requestBodyBlock(Block block) throws Exception {
    }

    protected void requestHeaderBlock(Block block) throws Exception {
    }

    protected void postVisitRequest(Request request) throws Exception {
    }

    @Override
    public void visit(Fault fault) throws Exception {
        this.preVisitFault(fault);
        this.visitFault(fault);
        this.postVisitFault(fault);
    }

    protected void preVisitFault(Fault fault) throws Exception {
    }

    protected void visitFault(Fault fault) throws Exception {
    }

    protected void postVisitFault(Fault fault) throws Exception {
    }

    protected void writeWarning(IndentingWriter indentingWriter) throws IOException {
        GeneratorBase.writeWarning(indentingWriter, this.targetVersion);
    }

    public List<String> getJAXWSClassComment() {
        return GeneratorBase.getJAXWSClassComment(this.targetVersion);
    }

    public static List<String> getJAXWSClassComment(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("This class was generated by the JAXWS SI.\n");
        arrayList.add(ToolVersion.VERSION.BUILD_VERSION + "\n");
        arrayList.add("Generated source version: " + string);
        return arrayList;
    }

    public static void writeWarning(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.pln("// This class was generated by the JAX SI, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln("// " + ToolVersion.VERSION.BUILD_VERSION);
        indentingWriter.pln("// Generated source version: " + string);
        indentingWriter.pln();
    }

    public void writePackage(IndentingWriter indentingWriter, String string) throws IOException {
        GeneratorBase.writePackage(indentingWriter, string, this.targetVersion);
    }

    public static void writePackage(IndentingWriter indentingWriter, String string, String string2) throws IOException {
        GeneratorBase.writeWarning(indentingWriter, string2);
        GeneratorBase.writePackageOnly(indentingWriter, string);
    }

    public static void writePackageOnly(IndentingWriter indentingWriter, String string) throws IOException {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            indentingWriter.pln("package " + string.substring(0, n) + ";");
            indentingWriter.pln();
        }
    }

    protected JDefinedClass getClass(String string, ClassType classType) {
        JDefinedClass jDefinedClass = null;
        try {
            jDefinedClass = this.cm._class(string, classType);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jDefinedClass = this.cm._getClass(string);
        }
        return jDefinedClass;
    }

    protected void log(String string) {
        if (this.env.verbose()) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + string + "]");
        }
    }

    protected void warn(String string) {
        this.env.warn(this.messageFactory.getMessage(string, new Object[0]));
    }

    protected void warn(String string, String string2) {
        this.env.warn(this.messageFactory.getMessage(string, new Object[]{string2}));
    }

    protected void warn(String string, Object[] objectArray) {
        this.env.warn(this.messageFactory.getMessage(string, objectArray));
    }

    protected void info(String string) {
        this.env.info(this.messageFactory.getMessage(string, new Object[0]));
    }

    protected void info(String string, String string2) {
        this.env.info(this.messageFactory.getMessage(string, new Object[]{string2}));
    }

    protected static void fail(String string) {
        throw new GeneratorException(string, new Object[0]);
    }

    protected static void fail(String string, String string2) {
        throw new GeneratorException(string, string2);
    }

    protected static void fail(String string, String string2, String string3) {
        throw new GeneratorException(string, string2, string3);
    }

    protected static void fail(Localizable localizable) {
        throw new GeneratorException("generator.nestedGeneratorError", localizable);
    }

    protected static void fail(Throwable throwable) {
        throw new GeneratorException("generator.nestedGeneratorError", throwable);
    }

    @Override
    public void visit(JAXBType jAXBType) throws Exception {
        this.preVisitJAXBType(jAXBType);
        this.visitJAXBType(jAXBType);
        this.postVisitJAXBType(jAXBType);
    }

    protected void postVisitJAXBType(JAXBType jAXBType) {
    }

    protected void visitJAXBType(JAXBType jAXBType) {
    }

    protected void preVisitJAXBType(JAXBType jAXBType) {
    }

    @Override
    public void visit(RpcLitStructure rpcLitStructure) throws Exception {
    }

    protected void writeHandlerConfig(String string, JDefinedClass jDefinedClass, WSDLModelInfo wSDLModelInfo) {
        Element element = wSDLModelInfo.getHandlerConfig();
        if (element == null) {
            return;
        }
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(HandlerChain.class));
        NodeList nodeList = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string2 = this.getHandlerConfigFileName(string);
            jAnnotationUse.param("file", string2);
            this.generateHandlerChainFile(element, string);
        }
    }

    private String getHandlerConfigFileName(String string) {
        String string2 = Names.stripQualifier(string);
        return string2 + "_handler.xml";
    }

    private void generateHandlerChainFile(Element element, String string) {
        String string2 = this.getHandlerConfigFileName(string);
        File file = DirectoryUtil.getOutputDirectoryFor(string, this.destDir, this.env);
        File file2 = new File(file, string2);
        GeneratedFileInfo generatedFileInfo = new GeneratedFileInfo();
        generatedFileInfo.setFile(file2);
        generatedFileInfo.setType("HandlerConfig");
        this.env.addGeneratedFile(generatedFileInfo);
        try {
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            Transformer transformer = XmlUtil.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(element), new StreamResult(indentingWriter));
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", exception);
        }
    }
}

