/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.server.QueryHandler;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;

public class FinalizerSummaryQuery
extends QueryHandler {
    public void run() {
        Enumeration enumeration = this.snapshot.getFinalizerObjects();
        this.startHtml("Finalizer Summary");
        this.out.println("<p align='center'>");
        this.out.println("<b><a href='/'>All Classes (excluding platform)</a></b>");
        this.out.println("</p>");
        this.printFinalizerSummary(enumeration);
        this.endHtml();
    }

    private void printFinalizerSummary(Enumeration enumeration) {
        HistogramElement[] histogramElementArray;
        int n = 0;
        HashMap<JavaClass, HistogramElement> hashMap = new HashMap<JavaClass, HistogramElement>();
        while (enumeration.hasMoreElements()) {
            histogramElementArray = (HistogramElement[])enumeration.nextElement();
            ++n;
            JavaClass javaClass = histogramElementArray.getClazz();
            if (!hashMap.containsKey(javaClass)) {
                hashMap.put(javaClass, new HistogramElement(javaClass));
            }
            HistogramElement histogramElement = (HistogramElement)hashMap.get(javaClass);
            histogramElement.updateCount();
        }
        this.out.println("<p align='center'>");
        this.out.println("<b>");
        this.out.println("Total ");
        if (n != 0) {
            this.out.print("<a href='/finalizerObjects/'>instances</a>");
        } else {
            this.out.print("instances");
        }
        this.out.println(" pending finalization: ");
        this.out.print(n);
        this.out.println("</b></p><hr>");
        if (n == 0) {
            return;
        }
        histogramElementArray = new HistogramElement[hashMap.size()];
        hashMap.values().toArray(histogramElementArray);
        Arrays.sort(histogramElementArray, new Comparator<HistogramElement>(){

            @Override
            public int compare(HistogramElement histogramElement, HistogramElement histogramElement2) {
                return histogramElement.compare(histogramElement2);
            }
        });
        this.out.println("<table border=1 align=center>");
        this.out.println("<tr><th>Count</th><th>Class</th></tr>");
        for (int i = 0; i < histogramElementArray.length; ++i) {
            this.out.println("<tr><td>");
            this.out.println(histogramElementArray[i].getCount());
            this.out.println("</td><td>");
            this.printClass(histogramElementArray[i].getClazz());
            this.out.println("</td><tr>");
        }
        this.out.println("</table>");
    }

    private static class HistogramElement {
        private JavaClass clazz;
        private long count;

        public HistogramElement(JavaClass javaClass) {
            this.clazz = javaClass;
        }

        public void updateCount() {
            ++this.count;
        }

        public int compare(HistogramElement histogramElement) {
            long l = histogramElement.count - this.count;
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }

        public JavaClass getClazz() {
            return this.clazz;
        }

        public long getCount() {
            return this.count;
        }
    }
}

