/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.util.Misc;

public class Root {
    private long id;
    private long refererId;
    private int index = -1;
    private int type;
    private String description;
    private JavaHeapObject referer = null;
    private StackTrace stackTrace = null;
    public static final int INVALID_TYPE = 0;
    public static final int UNKNOWN = 1;
    public static final int SYSTEM_CLASS = 2;
    public static final int NATIVE_LOCAL = 3;
    public static final int NATIVE_STATIC = 4;
    public static final int THREAD_BLOCK = 5;
    public static final int BUSY_MONITOR = 6;
    public static final int JAVA_LOCAL = 7;
    public static final int NATIVE_STACK = 8;
    public static final int JAVA_STATIC = 9;

    public Root(long l, long l2, int n, String string) {
        this(l, l2, n, string, null);
    }

    public Root(long l, long l2, int n, String string, StackTrace stackTrace) {
        this.id = l;
        this.refererId = l2;
        this.type = n;
        this.description = string;
        this.stackTrace = stackTrace;
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        return Misc.toHex(this.id);
    }

    public String getDescription() {
        if ("".equals(this.description)) {
            return this.getTypeName() + " Reference";
        }
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "Invalid (?!?)";
            }
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "System Class";
            }
            case 3: {
                return "JNI Local";
            }
            case 4: {
                return "JNI Global";
            }
            case 5: {
                return "Thread Block";
            }
            case 6: {
                return "Busy Monitor";
            }
            case 7: {
                return "Java Local";
            }
            case 8: {
                return "Native Stack (possibly Java local)";
            }
            case 9: {
                return "Java Static";
            }
        }
        return "??";
    }

    public Root mostInteresting(Root root) {
        if (root.type > this.type) {
            return root;
        }
        return this;
    }

    public JavaHeapObject getReferer() {
        return this.referer;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    public int getIndex() {
        return this.index;
    }

    void resolve(Snapshot snapshot) {
        if (this.refererId != 0L) {
            this.referer = snapshot.findThing(this.refererId);
        }
        if (this.stackTrace != null) {
            this.stackTrace.resolve(snapshot);
        }
    }

    void setIndex(int n) {
        this.index = n;
    }
}

