/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.type;

import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.type.AnnotationTypeImpl;
import com.sun.tools.apt.mirror.type.ArrayTypeImpl;
import com.sun.tools.apt.mirror.type.ClassTypeImpl;
import com.sun.tools.apt.mirror.type.DeclaredTypeImpl;
import com.sun.tools.apt.mirror.type.EnumTypeImpl;
import com.sun.tools.apt.mirror.type.InterfaceTypeImpl;
import com.sun.tools.apt.mirror.type.PrimitiveTypeImpl;
import com.sun.tools.apt.mirror.type.TypeVariableImpl;
import com.sun.tools.apt.mirror.type.VoidTypeImpl;
import com.sun.tools.apt.mirror.type.WildcardTypeImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMaker {
    private final AptEnv env;
    private final VoidType voidType;
    private PrimitiveType[] primTypes = new PrimitiveType[9];
    private static final Context.Key<TypeMaker> typeMakerKey = new Context.Key();

    public static TypeMaker instance(Context context) {
        TypeMaker typeMaker = context.get(typeMakerKey);
        if (typeMaker == null) {
            typeMaker = new TypeMaker(context);
        }
        return typeMaker;
    }

    private TypeMaker(Context context) {
        context.put(typeMakerKey, this);
        this.env = AptEnv.instance(context);
        this.voidType = new VoidTypeImpl(this.env);
        this.primTypes[8] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.BOOLEAN);
        this.primTypes[1] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.BYTE);
        this.primTypes[3] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.SHORT);
        this.primTypes[4] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.INT);
        this.primTypes[5] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.LONG);
        this.primTypes[2] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.CHAR);
        this.primTypes[6] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.FLOAT);
        this.primTypes[7] = new PrimitiveTypeImpl(this.env, PrimitiveType.Kind.DOUBLE);
    }

    public TypeMirror getType(Type type) {
        if (type.isPrimitive()) {
            return this.primTypes[type.tag];
        }
        switch (type.tag) {
            case 10: 
            case 19: {
                return this.getDeclaredType((Type.ClassType)type);
            }
            case 15: {
                return new WildcardTypeImpl(this.env, (Type.WildcardType)type);
            }
            case 14: {
                return new TypeVariableImpl(this.env, (Type.TypeVar)type);
            }
            case 11: {
                return new ArrayTypeImpl(this.env, (Type.ArrayType)type);
            }
            case 9: {
                return this.voidType;
            }
        }
        throw new AssertionError();
    }

    public DeclaredType getDeclaredType(Type.ClassType classType) {
        return TypeMaker.hasFlag(classType.tsym, 8192L) ? new AnnotationTypeImpl(this.env, classType) : (TypeMaker.hasFlag(classType.tsym, 512L) ? new InterfaceTypeImpl(this.env, classType) : (TypeMaker.hasFlag(classType.tsym, 16384L) ? new EnumTypeImpl(this.env, classType) : new ClassTypeImpl(this.env, classType)));
    }

    public Collection<TypeMirror> getTypes(Iterable<Type> iterable) {
        return this.getTypes(iterable, TypeMirror.class);
    }

    public <T extends TypeMirror> Collection<T> getTypes(Iterable<Type> iterable, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Type type : iterable) {
            TypeMirror typeMirror = this.getType(type);
            if (!clazz.isInstance(typeMirror)) continue;
            arrayList.add(clazz.cast(typeMirror));
        }
        return arrayList;
    }

    public String typeToString(Type type) {
        switch (type.tag) {
            case 11: {
                return this.typeToString(this.env.jctypes.elemtype(type)) + "[]";
            }
            case 10: {
                Type.ClassType classType = (Type.ClassType)type;
                return DeclaredTypeImpl.toString(this.env, classType);
            }
            case 15: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return WildcardTypeImpl.toString(this.env, wildcardType);
            }
        }
        return type.tsym.toString();
    }

    private static boolean hasFlag(Symbol symbol, long l) {
        return AptEnv.hasFlag(symbol, l);
    }
}

