/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.writer;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.writer.FilterCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final PrintStream progress;

    public ProgressCodeWriter(CodeWriter codeWriter, PrintStream printStream) {
        super(codeWriter);
        this.progress = printStream;
        if (printStream == null) {
            throw new IllegalArgumentException();
        }
    }

    public OutputStream openBinary(JPackage jPackage, String string) throws IOException {
        this.report(jPackage, string);
        return super.openBinary(jPackage, string);
    }

    public Writer openSource(JPackage jPackage, String string) throws IOException {
        this.report(jPackage, string);
        return super.openSource(jPackage, string);
    }

    private void report(JPackage jPackage, String string) {
        if (jPackage.isUnnamed()) {
            this.progress.println(string);
        } else {
            this.progress.println(jPackage.name().replace('.', File.separatorChar) + File.separatorChar + string);
        }
    }
}

