/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class UnicodeEscapeWriter
extends FilterWriter {
    public UnicodeEscapeWriter(Writer writer) {
        super(writer);
    }

    public final void write(int n) throws IOException {
        if (!this.requireEscaping(n)) {
            this.out.write(n);
        } else {
            this.out.write("\\u");
            String string = Integer.toHexString(n);
            for (int i = string.length(); i < 4; ++i) {
                this.out.write(48);
            }
            this.out.write(string);
        }
    }

    protected boolean requireEscaping(int n) {
        if (n >= 128) {
            return true;
        }
        return n < 32 && " \t\r\n".indexOf(n) == -1;
    }

    public final void write(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(cArray[n + i]);
        }
    }

    public final void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public final void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public final void write(String string) throws IOException {
        this.write(string.toCharArray(), 0, string.length());
    }
}

