/* 
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "mforms/mforms.h"

using namespace mforms;

FindPanel::FindPanel(CodeEditor *editor)
{
  _find_impl = &ControlFactory::get_instance()->_findpanel_impl;
  _editor = editor;
  _find_impl->create(this);
}


int FindPanel::perform_action(FindPanelAction action)
{
  return _find_impl->perform_action(this, action);
}


void FindPanel::focus()
{
  _find_impl->focus(this);
}

void FindPanel::enable_replace(bool flag)
{
  _find_impl->enable_replace(this, flag);
}