/* 
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_DOCKINGPOINT_H_
#define _WF_DOCKINGPOINT_H_

#pragma make_public(mforms::DockingPoint)
#pragma make_public(mforms::DockingPointDelegate)

using namespace System;

namespace MySQL {
  namespace Forms {
    class DockingPointDelegateProxy;

    public ref class DockingPointDelegateWrapper abstract
    {
      DockingPointDelegateProxy *_proxy;
    public:
      mforms::DockingPointDelegate* get_unmanaged_delegate();

      DockingPointDelegateWrapper(Object ^represented_object);
      ~DockingPointDelegateWrapper();

      virtual String ^get_type(Object ^represented_object) = 0;
      virtual void dock_view(Object ^represented_object, AppViewImpl ^view, String ^arg1, int arg2) = 0;
      virtual bool select_view(Object ^represented_object, AppViewImpl ^view) = 0;
      virtual void undock_view(Object ^represented_object, AppViewImpl ^view) = 0;
      virtual void set_view_title(Object ^represented_object, AppViewImpl ^view, String ^title) = 0;
      virtual void get_size(Object ^represented_object, [Out] int %w, [Out] int %h) = 0;
    };
  }
}

#endif
