# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit toolchain-funcs

# git.foss21.org is the official repository per upstream
DESCRIPTION="A surrogate ltdl implementation"
HOMEPAGE="https://git.foss21.org/sltdl"
if [[ "${PV}" == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://git.foss21.org/sltdl"
else
	VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/midipix.asc
	inherit verify-sig

	SRC_URI="https://dl.foss21.org/sltdl/${P}.tar.xz"
	SRC_URI+=" verify-sig? ( https://dl.foss21.org/sltdl/${P}.tar.xz.sig )"

	KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~m68k ~ppc ~ppc64 ~riscv ~x86"
fi

BDEPEND="sys-devel/m4"

if [[ "${PV}" != *9999 ]] ; then
	BDEPEND+=" verify-sig? ( >=sec-keys/openpgp-keys-midipix-20250517 )"
fi

LICENSE="MIT"
SLOT="0"

src_configure() {
	# Custom configure script (not generated by autoconf)
	./configure \
		--compiler="$(tc-getCC)" \
		--host="${CHOST}" \
		--prefix="${EPREFIX}"/usr \
		--libdir="${EPREFIX}/usr/$(get_libdir)" \
		--disable-static \
			|| die
}
