#
# @file    TestL3Compartment.py
# @brief   L3 Compartment unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3Compartment.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml

def isnan(x):
  return (x != x)
  pass

class TestL3Compartment(unittest.TestCase):

  global C
  C = None

  def setUp(self):
    self.C = libsbml.Compartment(3,1)
    if (self.C == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.C ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3_Compartment_NS(self):
    self.assertTrue( self.C.getNamespaces() != None )
    self.assertTrue( self.C.getNamespaces().getLength() == 1 )
    self.assertTrue((     "http://www.sbml.org/sbml/level3/version1/core" == self.C.getNamespaces().getURI(0) ))
    pass  

  def test_L3_Compartment_constant(self):
    self.assertTrue( self.C.isSetConstant() == False )
    self.C.setConstant(True)
    self.assertTrue( self.C.getConstant() == True )
    self.assertTrue( self.C.isSetConstant() == True )
    self.C.setConstant(False)
    self.assertTrue( self.C.getConstant() == False )
    self.assertTrue( self.C.isSetConstant() == True )
    pass  

  def test_L3_Compartment_create(self):
    self.assertTrue( self.C.getTypeCode() == libsbml.SBML_COMPARTMENT )
    self.assertTrue( self.C.getMetaId() == "" )
    self.assertTrue( self.C.getNotes() == None )
    self.assertTrue( self.C.getAnnotation() == None )
    self.assertTrue( self.C.getId() == "" )
    self.assertTrue( self.C.getName() == "" )
    self.assertTrue( self.C.getUnits() == "" )
    self.assertTrue( self.C.getOutside() == "" )
    self.assertEqual( True, isnan(self.C.getSpatialDimensionsAsDouble()) )
    self.assertEqual( True, isnan(self.C.getVolume()) )
    self.assertTrue( self.C.getConstant() == True )
    self.assertEqual( False, self.C.isSetId() )
    self.assertEqual( False, self.C.isSetSpatialDimensions() )
    self.assertEqual( False, self.C.isSetName() )
    self.assertEqual( False, self.C.isSetSize() )
    self.assertEqual( False, self.C.isSetVolume() )
    self.assertEqual( False, self.C.isSetUnits() )
    self.assertEqual( False, self.C.isSetOutside() )
    self.assertEqual( False, self.C.isSetConstant() )
    pass  

  def test_L3_Compartment_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(3,1)
    sbmlns.addNamespaces(xmlns)
    c = libsbml.Compartment(sbmlns)
    self.assertTrue( c.getTypeCode() == libsbml.SBML_COMPARTMENT )
    self.assertTrue( c.getMetaId() == "" )
    self.assertTrue( c.getNotes() == None )
    self.assertTrue( c.getAnnotation() == None )
    self.assertTrue( c.getLevel() == 3 )
    self.assertTrue( c.getVersion() == 1 )
    self.assertTrue( c.getNamespaces() != None )
    self.assertTrue( c.getNamespaces().getLength() == 2 )
    self.assertTrue( c.getId() == "" )
    self.assertTrue( c.getName() == "" )
    self.assertTrue( c.getUnits() == "" )
    self.assertTrue( c.getOutside() == "" )
    self.assertEqual( True, isnan(c.getSpatialDimensionsAsDouble()) )
    self.assertEqual( True, isnan(c.getVolume()) )
    self.assertTrue( c.getConstant() == True )
    self.assertEqual( False, c.isSetId() )
    self.assertEqual( False, c.isSetSpatialDimensions() )
    self.assertEqual( False, c.isSetName() )
    self.assertEqual( False, c.isSetSize() )
    self.assertEqual( False, c.isSetVolume() )
    self.assertEqual( False, c.isSetUnits() )
    self.assertEqual( False, c.isSetOutside() )
    self.assertEqual( False, c.isSetConstant() )
    _dummyList = [ c ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3_Compartment_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3_Compartment_hasRequiredAttributes(self):
    c = libsbml.Compartment(3,1)
    self.assertEqual( False, c.hasRequiredAttributes() )
    c.setId( "id")
    self.assertEqual( False, c.hasRequiredAttributes() )
    c.setConstant(False)
    self.assertEqual( True, c.hasRequiredAttributes() )
    _dummyList = [ c ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3_Compartment_id(self):
    id =  "mitochondria";
    self.assertEqual( False, self.C.isSetId() )
    self.C.setId(id)
    self.assertTrue(( id == self.C.getId() ))
    self.assertEqual( True, self.C.isSetId() )
    if (self.C.getId() == id):
      pass    
    pass  

  def test_L3_Compartment_initDefaults(self):
    c = libsbml.Compartment(3,1)
    c.setId( "A")
    self.assertEqual( True, c.isSetId() )
    self.assertEqual( False, c.isSetName() )
    self.assertEqual( False, c.isSetSize() )
    self.assertEqual( False, c.isSetVolume() )
    self.assertEqual( False, c.isSetUnits() )
    self.assertEqual( False, c.isSetConstant() )
    self.assertEqual( False, c.isSetSpatialDimensions() )
    c.initDefaults()
    self.assertTrue((  "A" == c.getId() ))
    self.assertTrue( c.getName() == "" )
    self.assertTrue((  "litre" == c.getUnits() ))
    self.assertTrue( c.getSpatialDimensions() == 3 )
    self.assertTrue( c.getSize() == 1 )
    self.assertTrue( c.getConstant() == True )
    self.assertEqual( True, c.isSetId() )
    self.assertEqual( False, c.isSetName() )
    self.assertEqual( False, c.isSetSize() )
    self.assertEqual( False, c.isSetVolume() )
    self.assertEqual( True, c.isSetUnits() )
    self.assertEqual( True, c.isSetConstant() )
    self.assertEqual( True, c.isSetSpatialDimensions() )
    _dummyList = [ c ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3_Compartment_name(self):
    name =  "My_Favorite_Factory";
    self.assertEqual( False, self.C.isSetName() )
    self.C.setName(name)
    self.assertTrue(( name == self.C.getName() ))
    self.assertEqual( True, self.C.isSetName() )
    if (self.C.getName() == name):
      pass    
    self.C.unsetName()
    self.assertEqual( False, self.C.isSetName() )
    if (self.C.getName() != None):
      pass    
    pass  

  def test_L3_Compartment_size(self):
    size = 0.2
    self.assertEqual( False, self.C.isSetSize() )
    self.assertEqual( True, isnan(self.C.getSize()) )
    self.C.setSize(size)
    self.assertTrue( self.C.getSize() == size )
    self.assertEqual( True, self.C.isSetSize() )
    self.C.unsetSize()
    self.assertEqual( False, self.C.isSetSize() )
    self.assertEqual( True, isnan(self.C.getSize()) )
    pass  

  def test_L3_Compartment_spatialDimensions(self):
    self.assertEqual( False, self.C.isSetSpatialDimensions() )
    self.assertEqual( True, isnan(self.C.getSpatialDimensionsAsDouble()) )
    self.C.setSpatialDimensions(1.5)
    self.assertEqual( True, self.C.isSetSpatialDimensions() )
    self.assertTrue( self.C.getSpatialDimensionsAsDouble() == 1.5 )
    self.C.unsetSpatialDimensions()
    self.assertEqual( False, self.C.isSetSpatialDimensions() )
    self.assertEqual( True, isnan(self.C.getSpatialDimensionsAsDouble()) )
    pass  

  def test_L3_Compartment_units(self):
    units =  "volume";
    self.assertEqual( False, self.C.isSetUnits() )
    self.C.setUnits(units)
    self.assertTrue(( units == self.C.getUnits() ))
    self.assertEqual( True, self.C.isSetUnits() )
    if (self.C.getUnits() == units):
      pass    
    self.C.unsetUnits()
    self.assertEqual( False, self.C.isSetUnits() )
    if (self.C.getUnits() != None):
      pass    
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestL3Compartment))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
